/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Files;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public final class StdoutSink
implements Utf8Sink,
Closeable {
    public static final StdoutSink INSTANCE = new StdoutSink();
    private final int bufferCapacity = 1024;
    private final long buffer = Unsafe.malloc(1024L, 19);
    private final long limit = this.buffer + 1024L;
    private long ptr = this.buffer;
    private final long stdout = Files.getStdOutFdInternal();

    @Override
    public void close() {
        Unsafe.free(this.buffer, 1024L, 19);
    }

    public void flush() {
        int len = (int)(this.ptr - this.buffer);
        if (len > 0) {
            Files.append(this.stdout, this.buffer, (long)len);
            this.ptr = this.buffer;
        }
    }

    @Override
    public Utf8Sink put(@Nullable Utf8Sequence us) {
        if (us != null) {
            int size = us.size();
            for (int i = 0; i < size; ++i) {
                this.put(us.byteAt(i));
            }
        }
        return this;
    }

    @Override
    public Utf8Sink put(byte b) {
        if (this.ptr == this.limit) {
            this.flush();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, b);
        return this;
    }

    @Override
    public Utf8Sink putNonAscii(long lo, long hi) {
        long remaining = hi - lo;
        while (remaining > 0L) {
            long avail = this.limit - this.ptr;
            if (avail > 0L) {
                long chunkSize = Math.min(avail, remaining);
                Vect.memcpy(this.ptr, hi - remaining, chunkSize);
                this.ptr += chunkSize;
                remaining -= chunkSize;
            }
            if (remaining <= 0L) continue;
            this.flush();
        }
        return this;
    }
}

