/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogram;
import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogramIterator;
import io.questdb.std.histogram.org.HdrHistogram.HistogramIterationValue;
import java.util.Iterator;

public class LinearIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    private long currentStepHighestValueReportingLevel;
    private long currentStepLowestValueReportingLevel;
    private long valueUnitsPerBucket;

    public LinearIterator(AbstractHistogram histogram, long valueUnitsPerBucket) {
        this.reset(histogram, valueUnitsPerBucket);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.currentStepHighestValueReportingLevel < this.nextValueAtIndex;
    }

    public void reset(long valueUnitsPerBucket) {
        this.reset(this.histogram, valueUnitsPerBucket);
    }

    private void reset(AbstractHistogram histogram, long valueUnitsPerBucket) {
        super.resetIterator(histogram);
        this.valueUnitsPerBucket = valueUnitsPerBucket;
        this.currentStepHighestValueReportingLevel = valueUnitsPerBucket - 1L;
        this.currentStepLowestValueReportingLevel = histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.currentStepHighestValueReportingLevel;
    }

    @Override
    void incrementIterationLevel() {
        this.currentStepHighestValueReportingLevel += this.valueUnitsPerBucket;
        this.currentStepLowestValueReportingLevel = this.histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.currentStepLowestValueReportingLevel || this.currentIndex >= this.histogram.countsArrayLength - 1;
    }
}

