/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.Barrier;
import io.questdb.mp.NullWaitStrategy;
import io.questdb.mp.SCSequence;
import io.questdb.mp.WaitStrategy;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class FanOut
implements Barrier {
    private static final long HOLDER = Unsafe.getFieldOffset(FanOut.class, "holder");
    private final Holder holder;
    private Barrier barrier;

    public FanOut(Barrier ... barriers) {
        Holder h = new Holder();
        for (int i = 0; i < barriers.length; ++i) {
            Barrier sq = barriers[i];
            h.barriers.add(sq);
            if (!sq.getWaitStrategy().acceptSignal()) continue;
            h.waitStrategies.add(sq.getWaitStrategy());
        }
        h.setupWaitStrategy();
        this.holder = h;
    }

    public static FanOut to(Barrier barrier) {
        return new FanOut(new Barrier[0]).and(barrier);
    }

    public FanOut and(Barrier barrier) {
        Holder _new;
        Holder h;
        Barrier root = null;
        long current = this.barrier != null ? this.barrier.current() : -1L;
        Unsafe.getUnsafe().loadFence();
        do {
            h = this.holder;
            if (h.barriers.indexOf(barrier) > -1) {
                return this;
            }
            if (root == null && this.barrier != null) {
                root = barrier.root();
                root.setBarrier(this.barrier);
                root.setCurrent(current);
                Unsafe.getUnsafe().storeFence();
            }
            _new = new Holder();
            _new.barriers.addAll(h.barriers);
            _new.barriers.add(barrier);
            _new.waitStrategies.addAll(h.waitStrategies);
            if (barrier.getWaitStrategy().acceptSignal()) {
                _new.waitStrategies.add(barrier.getWaitStrategy());
            }
            _new.setupWaitStrategy();
        } while (!Unsafe.getUnsafe().compareAndSwapObject(this, HOLDER, h, _new));
        if (root != null && this.barrier != null) {
            root.setCurrent(this.barrier.current());
        }
        Unsafe.getUnsafe().storeFence();
        return this;
    }

    @Override
    public long availableIndex(long lo) {
        long l = this.barrier.availableIndex(lo);
        ObjList<Barrier> barriers = this.holder.barriers;
        int n = barriers.size();
        for (int i = 0; i < n; ++i) {
            l = Math.min(l, barriers.getQuick(i).availableIndex(lo));
        }
        return l;
    }

    @Override
    public long current() {
        return this.barrier.current();
    }

    @Override
    public Barrier getBarrier() {
        return this.barrier;
    }

    @Override
    public WaitStrategy getWaitStrategy() {
        return this.holder.waitStrategy;
    }

    public void remove(SCSequence barrier) {
        Holder _new;
        Holder h;
        Unsafe.getUnsafe().storeFence();
        do {
            h = this.holder;
            if (h.barriers.indexOf(barrier) == -1) break;
            _new = new Holder();
            int n = h.barriers.size();
            for (int i = 0; i < n; ++i) {
                Barrier sq = h.barriers.getQuick(i);
                if (sq == barrier) continue;
                _new.barriers.add(sq);
            }
            WaitStrategy that = barrier.getWaitStrategy();
            if (that.acceptSignal()) {
                int n2 = h.waitStrategies.size();
                for (int i = 0; i < n2; ++i) {
                    WaitStrategy ws = h.waitStrategies.getQuick(i);
                    if (ws == that) continue;
                    _new.waitStrategies.add(ws);
                }
            } else {
                _new.waitStrategies.addAll(h.waitStrategies);
            }
            _new.setupWaitStrategy();
        } while (!Unsafe.getUnsafe().compareAndSwapObject(this, HOLDER, h, _new));
        barrier.reset();
    }

    @Override
    public Barrier root() {
        return this.barrier != null ? this.barrier.root() : this;
    }

    @Override
    public void setBarrier(Barrier barrier) {
        this.barrier = barrier;
        ObjList<Barrier> barriers = this.holder.barriers;
        int n = barriers.size();
        for (int i = 0; i < n; ++i) {
            barriers.getQuick(i).root().setBarrier(barrier);
        }
    }

    @Override
    public void setCurrent(long value) {
        ObjList<Barrier> barriers = this.holder.barriers;
        int n = barriers.size();
        for (int i = 0; i < n; ++i) {
            barriers.getQuick(i).setCurrent(value);
        }
    }

    @Override
    public Barrier then(Barrier barrier) {
        barrier.setBarrier(this);
        return barrier;
    }

    private static class Holder {
        private final ObjList<Barrier> barriers = new ObjList();
        private final FanOutWaitStrategy fanOutWaitStrategy = new FanOutWaitStrategy();
        private final ObjList<WaitStrategy> waitStrategies = new ObjList();
        private WaitStrategy waitStrategy;

        private Holder() {
        }

        private void setupWaitStrategy() {
            this.waitStrategy = this.waitStrategies.size() > 0 ? this.fanOutWaitStrategy : NullWaitStrategy.INSTANCE;
        }

        private class FanOutWaitStrategy
        implements WaitStrategy {
            private FanOutWaitStrategy() {
            }

            @Override
            public boolean acceptSignal() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    if (!Holder.this.waitStrategies.getQuick(i).acceptSignal()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void alert() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    Holder.this.waitStrategies.getQuick(i).alert();
                }
            }

            @Override
            public void await() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    Holder.this.waitStrategies.getQuick(i).await();
                }
            }

            @Override
            public void signal() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    Holder.this.waitStrategies.getQuick(i).signal();
                }
            }
        }
    }
}

