/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.sql.OperationFuture;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.DoneOperationFuture;
import io.questdb.griffin.engine.ops.Operation;
import io.questdb.mp.SCSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDropOperation
implements Operation {
    private final String entityName;
    private final int entityNamePosition;
    private final DoneOperationFuture future = new DoneOperationFuture();
    private final boolean ifExists;
    private final int operationCode;
    private final String sqlText;

    public GenericDropOperation(int operationCode, @Nullable String sqlText, @NotNull String entityName, int entityNamePosition, boolean ifExists) {
        this.operationCode = operationCode;
        this.sqlText = sqlText;
        this.entityName = entityName;
        this.entityNamePosition = entityNamePosition;
        this.ifExists = ifExists;
    }

    @Override
    public void close() {
    }

    @Override
    public OperationFuture execute(SqlExecutionContext sqlExecutionContext, @Nullable SCSequence eventSubSeq) throws SqlException {
        try (SqlCompiler compiler = sqlExecutionContext.getCairoEngine().getSqlCompiler();){
            compiler.execute(this, sqlExecutionContext);
        }
        return this.future;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public int getEntityNamePosition() {
        return this.entityNamePosition;
    }

    @Override
    public int getOperationCode() {
        return this.operationCode;
    }

    @Override
    public OperationFuture getOperationFuture() {
        return this.future;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public boolean ifExists() {
        return this.ifExists;
    }
}

