/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.PartitionBy;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.CreateMatViewOperation;
import io.questdb.griffin.engine.ops.CreateMatViewOperationBuilder;
import io.questdb.griffin.engine.ops.CreateMatViewOperationImpl;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilderImpl;
import io.questdb.griffin.engine.ops.CreateTableOperationImpl;
import io.questdb.griffin.engine.table.ShowCreateTableRecordCursorFactory;
import io.questdb.griffin.model.CreateTableColumnModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMatViewOperationBuilderImpl
implements CreateMatViewOperationBuilder,
Mutable,
Sinkable {
    public static final ObjectFactory<CreateMatViewOperationBuilderImpl> FACTORY = CreateMatViewOperationBuilderImpl::new;
    private final CreateTableOperationBuilderImpl createTableOperationBuilder = new CreateTableOperationBuilderImpl();
    private String baseTableName;
    private int baseTableNamePosition;
    private boolean deferred;
    private int periodDelay;
    private char periodDelayUnit;
    private int periodLength;
    private char periodLengthUnit;
    private int refreshType = -1;
    private String timeZone;
    private String timeZoneOffset;
    private int timerInterval;
    private long timerStart = Long.MIN_VALUE;
    private String timerTimeZone;
    private char timerUnit;

    @Override
    public CreateMatViewOperation build(SqlCompiler compiler, SqlExecutionContext sqlExecutionContext, CharSequence sqlText) throws SqlException {
        CreateTableOperationImpl createTableOperation = this.createTableOperationBuilder.build(compiler, sqlExecutionContext, sqlText);
        return new CreateMatViewOperationImpl(Chars.toString(sqlText), createTableOperation, this.refreshType, this.deferred, this.baseTableName, this.baseTableNamePosition, this.timeZone, this.timeZoneOffset, this.timerInterval, this.timerUnit, this.timerStart, this.timerTimeZone, this.periodLength, this.periodLengthUnit, this.periodDelay, this.periodDelayUnit);
    }

    @Override
    public void clear() {
        this.createTableOperationBuilder.clear();
        this.refreshType = -1;
        this.deferred = false;
        this.baseTableName = null;
        this.baseTableNamePosition = 0;
        this.timeZone = null;
        this.timeZoneOffset = null;
        this.timerInterval = 0;
        this.timerUnit = '\u0000';
        this.timerStart = Long.MIN_VALUE;
        this.timerTimeZone = null;
        this.periodLength = 0;
        this.periodLengthUnit = '\u0000';
        this.periodDelay = 0;
        this.periodDelayUnit = '\u0000';
    }

    public CreateTableOperationBuilderImpl getCreateTableOperationBuilder() {
        return this.createTableOperationBuilder;
    }

    @Override
    public QueryModel getQueryModel() {
        return this.createTableOperationBuilder.getQueryModel();
    }

    @Override
    public CharSequence getTableName() {
        return this.createTableOperationBuilder.getTableName();
    }

    @Override
    public ExpressionNode getTableNameExpr() {
        return this.createTableOperationBuilder.getTableNameExpr();
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public void setBaseTableNamePosition(int baseTableNamePosition) {
        this.baseTableNamePosition = baseTableNamePosition;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public void setPeriodLength(int length, char lengthUnit, int delay, char delayUnit) {
        this.periodLength = length;
        this.periodLengthUnit = lengthUnit;
        this.periodDelay = delay;
        this.periodDelayUnit = delayUnit;
    }

    public void setRefreshType(int refreshType) {
        this.refreshType = refreshType;
    }

    @Override
    public void setSelectModel(QueryModel selectModel) {
        this.createTableOperationBuilder.setSelectModel(selectModel);
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public void setTimer(@Nullable String timeZone, long start, int interval, char unit) {
        this.timerTimeZone = timeZone;
        this.timerStart = start;
        this.timerInterval = interval;
        this.timerUnit = unit;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("create materialized view ");
        sink.put(this.createTableOperationBuilder.getTableName());
        if (this.baseTableName != null) {
            sink.putAscii(" with base ");
            sink.put(this.baseTableName);
        }
        sink.putAscii(" refresh");
        if (this.refreshType == 1) {
            sink.putAscii(" every ");
            sink.put(this.timerInterval);
            sink.putAscii(this.timerUnit);
            if (this.deferred) {
                sink.putAscii(" deferred");
            }
            if (this.periodLength == 0) {
                sink.putAscii(" start '");
                sink.putISODate(this.timerStart);
                if (this.timerTimeZone != null) {
                    sink.putAscii("' time zone '");
                    sink.put(this.timerTimeZone);
                }
                sink.putAscii('\'');
            }
        } else if (this.refreshType == 0) {
            sink.putAscii(" immediate");
            if (this.deferred) {
                sink.putAscii(" deferred");
            }
        } else if (this.refreshType == 2) {
            sink.putAscii(" manual");
            if (this.deferred) {
                sink.putAscii(" deferred");
            }
        }
        if (this.periodLength > 0) {
            sink.putAscii(" period (length ");
            sink.put(this.periodLength);
            sink.putAscii(this.periodLengthUnit);
            if (this.timerTimeZone != null) {
                sink.putAscii(" time zone '");
                sink.put(this.timerTimeZone);
                sink.putAscii('\'');
            }
            if (this.periodDelay > 0) {
                sink.putAscii(" delay ");
                sink.put(this.periodDelay);
                sink.putAscii(this.periodDelayUnit);
            }
            sink.putAscii(')');
        }
        sink.putAscii(" as (");
        if (this.createTableOperationBuilder.getQueryModel() != null) {
            this.createTableOperationBuilder.getQueryModel().toSink(sink);
        }
        sink.putAscii(')');
        int n = this.createTableOperationBuilder.getColumnCount();
        for (int i = 0; i < n; ++i) {
            CharSequence columnName = this.createTableOperationBuilder.getColumnName(i);
            CreateTableColumnModel columnModel = this.createTableOperationBuilder.getColumnModel(columnName);
            if (columnModel == null || !columnModel.isIndexed()) continue;
            sink.putAscii(", index(");
            sink.put(columnName);
            sink.putAscii(" capacity ");
            sink.put(columnModel.getIndexValueBlockSize());
            sink.putAscii(')');
        }
        if (this.createTableOperationBuilder.getTimestampExpr() != null) {
            sink.putAscii(" timestamp(");
            this.createTableOperationBuilder.getTimestampExpr().toSink(sink);
            sink.putAscii(')');
        }
        if (this.createTableOperationBuilder.getPartitionByFromExpr() != 3) {
            sink.putAscii(" partition by ").put(PartitionBy.toString(this.createTableOperationBuilder.getPartitionByFromExpr()));
        }
        int ttlHoursOrMonths = this.createTableOperationBuilder.getTtlHoursOrMonths();
        ShowCreateTableRecordCursorFactory.ttlToSink(ttlHoursOrMonths, sink);
        CharSequence volumeAlias = this.createTableOperationBuilder.getVolumeAlias();
        if (volumeAlias != null) {
            sink.putAscii(" in volume '").put(volumeAlias).putAscii('\'');
        }
    }
}

