/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Hash;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class GroupByIntHashSet {
    private static final long HEADER_SIZE = 12L;
    private static final int MIN_INITIAL_CAPACITY = 2;
    private static final long SIZE_LIMIT_OFFSET = 8L;
    private static final long SIZE_OFFSET = 4L;
    private final int initialCapacity;
    private final double loadFactor;
    private final int noKeyValue;
    private GroupByAllocator allocator;
    private long mask;
    private long ptr;

    public GroupByIntHashSet(int initialCapacity, double loadFactor, int noKeyValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.noKeyValue = noKeyValue;
        this.initialCapacity = Numbers.ceilPow2((int)((double)Math.max(initialCapacity, 2) / loadFactor));
        this.loadFactor = loadFactor;
    }

    public boolean add(int key) {
        long index = this.keyIndex(key);
        if (index < 0L) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(long index, int key) {
        this.setKeyAt(index, key);
        int size = this.size();
        int sizeLimit = this.sizeLimit();
        Unsafe.getUnsafe().putInt(this.ptr + 4L, ++size);
        if (size >= sizeLimit) {
            this.rehash(this.capacity() << 1, sizeLimit << 1);
        }
    }

    public int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    public int keyAt(long index) {
        return Unsafe.getUnsafe().getInt(this.ptr + 12L + 4L * index);
    }

    public long keyIndex(int key) {
        long hashCode = Hash.hashInt64(key);
        long index = hashCode & this.mask;
        int k = this.keyAt(index);
        if (k == this.noKeyValue) {
            return index;
        }
        if (key == k) {
            return -index - 1L;
        }
        return this.probe(key, index);
    }

    public void merge(GroupByIntHashSet srcSet) {
        long lim = srcSet.ptr + 12L + 4L * (long)srcSet.capacity();
        for (long p = srcSet.ptr + 12L; p < lim; p += 4L) {
            long index;
            int val = Unsafe.getUnsafe().getInt(p);
            if (val == this.noKeyValue || (index = this.keyIndex(val)) < 0L) continue;
            this.addAt(index, val);
        }
    }

    public GroupByIntHashSet of(long ptr) {
        if (ptr == 0L) {
            this.ptr = this.allocator.malloc(12L + 4L * (long)this.initialCapacity);
            this.zero(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putInt(this.ptr + 8L, (int)((double)this.initialCapacity * this.loadFactor));
            this.mask = this.initialCapacity - 1;
        } else {
            this.ptr = ptr;
            this.mask = this.capacity() - 1;
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void resetPtr() {
        this.ptr = 0L;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    public int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    public int sizeLimit() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 8L) : 0;
    }

    private long probe(int key, long index) {
        long index0 = index;
        do {
            int k;
            if ((k = this.keyAt(index = index + 1L & this.mask)) == this.noKeyValue) {
                return index;
            }
            if (key != k) continue;
            return -index - 1L;
        } while (index != index0);
        throw CairoException.critical(0).put("corrupt int hash set");
    }

    private void rehash(int newCapacity, int newSizeLimit) {
        if (newCapacity < 0) {
            throw CairoException.nonCritical().put("int hash set capacity overflow");
        }
        int oldSize = this.size();
        int oldCapacity = this.capacity();
        long oldPtr = this.ptr;
        this.ptr = this.allocator.malloc(12L + 4L * (long)newCapacity);
        this.zero(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, oldSize);
        Unsafe.getUnsafe().putInt(this.ptr + 8L, newSizeLimit);
        this.mask = newCapacity - 1;
        long lim = oldPtr + 12L + 4L * (long)oldCapacity;
        for (long p = oldPtr + 12L; p < lim; p += 4L) {
            int key = Unsafe.getUnsafe().getInt(p);
            if (key == this.noKeyValue) continue;
            long index = this.keyIndex(key);
            this.setKeyAt(index, key);
        }
        this.allocator.free(oldPtr, 12L + 4L * (long)oldCapacity);
    }

    private void setKeyAt(long index, int key) {
        Unsafe.getUnsafe().putInt(this.ptr + 12L + 4L * index, key);
    }

    private void zero(long ptr, int cap) {
        if (this.noKeyValue == 0) {
            Vect.memset(ptr + 12L, 4L * (long)cap, 0);
        } else {
            long lim = ptr + 12L + 4L * (long)cap;
            for (long p = ptr + 12L; p < lim; p += 4L) {
                Unsafe.getUnsafe().putInt(p, this.noKeyValue);
            }
        }
    }
}

