/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.rnd.RndStrFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.Sinkable;

public class RndStringListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_str(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args == null) {
            return new RndStrFunction(3, 10, 1);
        }
        ObjList<String> symbols = new ObjList<String>(args.size());
        RndStringListFunctionFactory.copyConstants(args, argPositions, symbols);
        return new Func(symbols);
    }

    static void copyConstants(ObjList<Function> args, IntList argPositions, ObjList<String> symbols) throws SqlException {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function f = args.getQuick(i);
            if (f.isConstant()) {
                short typeTag = ColumnType.tagOf(f.getType());
                if (typeTag == 11 || typeTag == 33) {
                    symbols.add(Chars.toString(f.getStrA(null)));
                    continue;
                }
                if (typeTag == 4) {
                    symbols.add(String.valueOf(f.getChar(null)));
                    continue;
                }
            }
            throw SqlException.$(argPositions.getQuick(i), "STRING constant expected");
        }
    }

    private static final class Func
    extends StrFunction
    implements Function {
        private final int count;
        private final ObjList<String> symbols;
        private Rnd rnd;

        public Func(ObjList<String> symbols) {
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.symbols.getQuick(this.rnd.nextPositiveInt() % this.count);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStrA(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_str(").val((Sinkable)this.symbols).val(')');
        }
    }
}

