/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.cast.CastDoubleToFloatFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToByteFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToDateFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToIntFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToShortFunctionFactory;
import io.questdb.griffin.engine.functions.cast.CastLongToTimestampFunctionFactory;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class LeastNumericFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<int[]> tlCounters = ThreadLocal.withInitial(() -> new int[34]);

    @Override
    public String getSignature() {
        return "least(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int argCount;
        int[] counters = tlCounters.get();
        Arrays.fill(counters, 0);
        if (args == null || (argCount = args.size()) == 0) {
            throw SqlException.$(position, "at least one argument is required by LEAST(V)");
        }
        block3: for (int i = 0; i < argCount; ++i) {
            Function arg = args.getQuick(i);
            int type = arg.getType();
            switch (ColumnType.tagOf(type)) {
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 33: {
                    int n = type;
                    counters[n] = counters[n] + 1;
                    continue block3;
                }
                default: {
                    throw SqlException.position(argPositions.getQuick(i)).put("unsupported type: ").put(ColumnType.nameOf(type));
                }
            }
        }
        if (counters[33] == argCount) {
            return NullConstant.NULL;
        }
        Function retVal = LeastNumericFunctionFactory.getLeastFunction(new ObjList<Function>(args), counters);
        if (retVal != null) {
            return retVal;
        }
        throw SqlException.position(argPositions.getQuick(0)).put("unexpected argument types");
    }

    @Nullable
    private static Function getLeastFunction(ObjList<Function> args, int[] counters) {
        if (counters[10] > 0) {
            return new LeastDoubleRecordFunction(args);
        }
        if (counters[9] > 0) {
            return new CastDoubleToFloatFunctionFactory.CastDoubleToFloatFunction(new LeastDoubleRecordFunction(args));
        }
        if (counters[6] > 0) {
            return new LeastLongRecordFunction(args);
        }
        if (counters[7] > 0) {
            return new CastLongToDateFunctionFactory.CastLongToDateFunction(new LeastLongRecordFunction(args));
        }
        if (counters[8] > 0) {
            return new CastLongToTimestampFunctionFactory.CastLongToTimestampFunction(new LeastLongRecordFunction(args));
        }
        if (counters[5] > 0) {
            return new CastLongToIntFunctionFactory.CastLongToIntFunction(new LeastLongRecordFunction(args));
        }
        if (counters[3] > 0) {
            return new CastLongToShortFunctionFactory.CastLongToShortFunction(new LeastLongRecordFunction(args));
        }
        if (counters[2] > 0) {
            return new CastLongToByteFunctionFactory.CastLongToByteFunction(new LeastLongRecordFunction(args));
        }
        return null;
    }

    private static class LeastDoubleRecordFunction
    extends DoubleFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int n;

        public LeastDoubleRecordFunction(ObjList<Function> args) {
            this.args = args;
            this.n = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public double getDouble(Record rec) {
            double value = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.n; ++i) {
                double v = this.args.getQuick(i).getDouble(rec);
                if (Numbers.isNull(v)) continue;
                value = Math.min(value, v);
            }
            return value;
        }

        @Override
        public String getName() {
            return "least[DOUBLE]";
        }
    }

    private static class LeastLongRecordFunction
    extends LongFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;
        private final int n;

        public LeastLongRecordFunction(ObjList<Function> args) {
            this.args = args;
            this.n = args.size();
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public long getLong(Record rec) {
            long value = Long.MAX_VALUE;
            boolean foundValidValue = false;
            for (int i = 0; i < this.n; ++i) {
                long v = this.args.getQuick(i).getLong(rec);
                if (v == Long.MIN_VALUE) continue;
                foundValidValue = true;
                value = Math.min(value, v);
            }
            return foundValidValue ? value : Long.MIN_VALUE;
        }

        @Override
        public String getName() {
            return "least[LONG]";
        }
    }
}

