/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.groupby.FirstCharGroupByFunction;
import org.jetbrains.annotations.NotNull;

public class LastNotNullCharGroupByFunction
extends FirstCharGroupByFunction {
    public LastNotNullCharGroupByFunction(int position, @NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (this.arg.getChar(record) != CharConstant.ZERO.getChar(null)) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "last_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        char srcVal = srcValue.getChar(this.valueIndex + 1);
        if (srcVal == CharConstant.ZERO.getChar(null)) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putChar(this.valueIndex + 1, srcVal);
        }
    }
}

