/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstDateGroupByFunction;
import org.jetbrains.annotations.NotNull;

public class FirstNotNullDateGroupByFunction
extends FirstDateGroupByFunction {
    public FirstNotNullDateGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (mapValue.getDate(this.valueIndex + 1) == Long.MIN_VALUE) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "first_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcVal = srcValue.getDate(this.valueIndex + 1);
        if (srcVal == Long.MIN_VALUE) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putDate(this.valueIndex + 1, srcVal);
        }
    }
}

