/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;

public class EqVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(\u00d8\u00d8)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant()) {
            return this.createHalfConstantFunc(a, b);
        }
        if (b.isConstant()) {
            return this.createHalfConstantFunc(b, a);
        }
        if (a.isRuntimeConstant()) {
            return new HalfRuntimeConstFunc(a, b);
        }
        if (b.isRuntimeConstant()) {
            return new HalfRuntimeConstFunc(b, a);
        }
        return new Func(a, b);
    }

    private Function createHalfConstantFunc(Function constFunc, Function varFunc) {
        Utf8Sequence constValue = constFunc.getVarcharA(null);
        if (constValue == null) {
            return new NullCheckFunc(varFunc);
        }
        return new ConstCheckFunc(varFunc, constValue);
    }

    static class HalfRuntimeConstFunc
    extends AbstractEqBinaryFunction {
        private Utf8Sequence cachedRuntimeConst;
        private long cachedSixPrefix;

        HalfRuntimeConstFunc(Function runtimeConst, Function arg) {
            super(arg, runtimeConst);
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence a = this.left.getVarcharA(rec);
            Utf8Sequence b = this.cachedRuntimeConst;
            if (a == null || b == null) {
                return this.negated != (a == b);
            }
            return this.negated != Utf8s.equals(a, a.zeroPaddedSixPrefix(), b, this.cachedSixPrefix);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            this.cachedRuntimeConst = this.right.getVarcharA(null);
            this.cachedSixPrefix = this.cachedRuntimeConst != null ? this.cachedRuntimeConst.zeroPaddedSixPrefix() : 0L;
        }
    }

    static class Func
    extends AbstractEqBinaryFunction {
        Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence a = this.left.getVarcharA(rec);
            Utf8Sequence b = this.right.getVarcharB(rec);
            if (a == null) {
                return this.negated != (b == null);
            }
            return this.negated != Utf8s.equals(a, b);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return "!=";
            }
            return "=";
        }
    }

    public static class NullCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;

        public NullCheckFunc(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != ((long)this.arg.getVarcharSize(rec) == -1L);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(" is not null");
            } else {
                sink.val(" is null");
            }
        }
    }

    static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final Utf8Sequence constant;
        private final long constantSixPrefix;

        ConstCheckFunc(Function arg, @NotNull Utf8Sequence constant) {
            this.arg = arg;
            this.constant = constant;
            this.constantSixPrefix = constant.zeroPaddedSixPrefix();
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            Utf8Sequence val = this.arg.getVarcharA(rec);
            return this.negated != (val != null && Utf8s.equals(val, val.zeroPaddedSixPrefix(), this.constant, this.constantSixPrefix));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }
}

