/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DoubleArrayParser;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastStrToDoubleArrayFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sd[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function typeFunc = args.getQuick(1);
        int type = typeFunc.getType();
        return new Func(args.getQuick(0), type);
    }

    public static class Func
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arg;
        private final int dims;
        private final DoubleArrayParser parser = new DoubleArrayParser();

        public Func(Function arg, int type) {
            this.type = type;
            this.dims = ColumnType.decodeArrayDimensionality(type);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            CharSequence str = this.arg.getStrA(rec);
            assert (str != null);
            assert (str.length() > 0);
            try {
                this.parser.of(str, this.dims);
            }
            catch (IllegalArgumentException e) {
                this.parser.of(null);
            }
            return this.parser;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getArg()).val("::DOUBLE");
            for (int i = 0; i < this.dims; ++i) {
                sink.val("[]");
            }
        }
    }
}

