/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.CreateMatViewOperationBuilder;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilder;
import io.questdb.griffin.engine.table.ShowCreateMatViewRecordCursorFactory;
import io.questdb.griffin.engine.table.ShowCreateTableRecordCursorFactory;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.GenericLexer;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqlParserCallback {
    @NotNull
    public static TableToken getMatViewToken(ExpressionNode tableNameExpr, SqlExecutionContext executionContext, Path path) throws SqlException {
        TableToken viewToken = SqlParserCallback.getTableToken(tableNameExpr, executionContext, path, SqlException.matViewDoesNotExist(tableNameExpr.position, tableNameExpr.token));
        if (!viewToken.isMatView()) {
            throw SqlException.$(tableNameExpr.position, "materialized view name expected, got table name");
        }
        return viewToken;
    }

    public static TableToken getTableToken(ExpressionNode tableNameExpr, SqlExecutionContext executionContext, Path path) throws SqlException {
        return SqlParserCallback.getTableToken(tableNameExpr, executionContext, path, SqlException.tableDoesNotExist(tableNameExpr.position, tableNameExpr.token));
    }

    default public RecordCursorFactory generateShowCreateMatViewFactory(QueryModel model, SqlExecutionContext executionContext, Path path) throws SqlException {
        TableToken viewToken = SqlParserCallback.getMatViewToken(model.getTableNameExpr(), executionContext, path);
        return new ShowCreateMatViewRecordCursorFactory(viewToken, model.getTableNameExpr().position);
    }

    default public RecordCursorFactory generateShowCreateTableFactory(QueryModel model, SqlExecutionContext executionContext, Path path) throws SqlException {
        TableToken tableToken = SqlParserCallback.getTableToken(model.getTableNameExpr(), executionContext, path);
        return new ShowCreateTableRecordCursorFactory(tableToken, model.getTableNameExpr().position);
    }

    default public RecordCursorFactory generateShowSqlFactory(QueryModel model) {
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    default public CreateMatViewOperationBuilder parseCreateMatViewExt(GenericLexer lexer, SecurityContext securityContext, CreateMatViewOperationBuilder builder, @Nullable CharSequence tok) throws SqlException {
        if (tok != null) {
            throw SqlException.unexpectedToken(lexer.lastTokenPosition(), tok);
        }
        return builder;
    }

    default public CreateTableOperationBuilder parseCreateTableExt(GenericLexer lexer, SecurityContext securityContext, CreateTableOperationBuilder builder, @Nullable CharSequence tok) throws SqlException {
        if (tok != null) {
            throw SqlException.unexpectedToken(lexer.lastTokenPosition(), tok);
        }
        return builder;
    }

    default public int parseShowSql(GenericLexer lexer, QueryModel model, CharSequence tok, ObjectPool<ExpressionNode> expressionNodePool) throws SqlException {
        return -1;
    }

    private static TableToken getTableToken(ExpressionNode tableNameExpr, SqlExecutionContext executionContext, Path path, SqlException notExistsError) throws SqlException {
        TableToken tableToken = executionContext.getTableTokenIfExists(tableNameExpr.token);
        if (executionContext.getTableStatus(path, tableToken) != 0) {
            throw notExistsError;
        }
        return tableToken;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

