/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.ImplicitCastException;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorState;
import io.questdb.cutlass.http.processors.TextQueryProcessorState;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.QueryPausedException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.Interval;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Uuid;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class TextQueryProcessor
implements HttpRequestProcessor,
HttpRequestHandler,
Closeable {
    private static final Log LOG = LogFactory.getLog(TextQueryProcessor.class);
    private static final LocalValue<TextQueryProcessorState> LV = new LocalValue();
    private final NetworkSqlExecutionCircuitBreaker circuitBreaker;
    private final MillisecondClock clock;
    private final JsonQueryProcessorConfiguration configuration;
    private final CairoEngine engine;
    private final int maxSqlRecompileAttempts;
    private final Metrics metrics;
    private final byte requiredAuthType;
    private final SqlExecutionContextImpl sqlExecutionContext;

    public TextQueryProcessor(JsonQueryProcessorConfiguration configuration, CairoEngine engine, int sharedQueryWorkerCount) {
        this.configuration = configuration;
        this.clock = configuration.getMillisecondClock();
        this.sqlExecutionContext = new SqlExecutionContextImpl(engine, sharedQueryWorkerCount);
        this.circuitBreaker = new NetworkSqlExecutionCircuitBreaker(engine.getConfiguration().getCircuitBreakerConfiguration(), 22);
        this.metrics = engine.getMetrics();
        this.engine = engine;
        this.maxSqlRecompileAttempts = engine.getConfiguration().getMaxSqlRecompileAttempts();
        this.requiredAuthType = configuration.getRequiredAuthType();
    }

    @Override
    public void close() {
        Misc.free(this.circuitBreaker);
    }

    public void execute(HttpConnectionContext context, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        block29: {
            try {
                boolean isExpRequest = TextQueryProcessor.isExpUrl(context.getRequestHeader().getUrl());
                this.circuitBreaker.resetTimer();
                state.recordCursorFactory = context.getSelectCache().poll(state.query);
                state.setQueryCacheable(true);
                this.sqlExecutionContext.with(context.getSecurityContext(), null, null, context.getFd(), this.circuitBreaker.of(context.getFd()));
                this.sqlExecutionContext.initNow();
                if (state.recordCursorFactory == null) {
                    try (SqlCompiler compiler = this.engine.getSqlCompiler();){
                        CompiledQuery cc = compiler.compile(state.query, this.sqlExecutionContext);
                        if (cc.getType() == 1 || cc.getType() == 25) {
                            state.recordCursorFactory = cc.getRecordCursorFactory();
                        } else if (isExpRequest) {
                            throw SqlException.$(0, "/exp endpoint only accepts SELECT");
                        }
                        this.sqlExecutionContext.storeTelemetry(cc.getType(), (short)4);
                    }
                } else {
                    this.sqlExecutionContext.setCacheHit(true);
                    this.sqlExecutionContext.storeTelemetry((short)1, (short)4);
                }
                if (state.recordCursorFactory != null) {
                    try {
                        boolean runQuery = true;
                        int retries = 0;
                        while (runQuery) {
                            try {
                                state.cursor = state.recordCursorFactory.getCursor(this.sqlExecutionContext);
                                runQuery = false;
                            }
                            catch (TableReferenceOutOfDateException e) {
                                if (retries == this.maxSqlRecompileAttempts) {
                                    throw SqlException.$(0, e.getFlyweightMessage());
                                }
                                this.info(state).$safe(e.getFlyweightMessage()).$();
                                state.recordCursorFactory = Misc.free(state.recordCursorFactory);
                                try (SqlCompiler compiler = this.engine.getSqlCompiler();){
                                    CompiledQuery cc = compiler.compile(state.query, this.sqlExecutionContext);
                                    if (cc.getType() != 1 && isExpRequest) {
                                        throw SqlException.$(0, "/exp endpoint only accepts SELECT");
                                    }
                                    state.recordCursorFactory = cc.getRecordCursorFactory();
                                }
                            }
                            ++retries;
                        }
                        state.metadata = state.recordCursorFactory.getMetadata();
                        this.doResumeSend(context);
                    }
                    catch (CairoException e) {
                        state.setQueryCacheable(e.isCacheable());
                        this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e, state);
                    }
                    catch (CairoError e) {
                        this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e, state);
                    }
                    break block29;
                }
                this.headerNoContentDisposition(context.getChunkedResponse());
                this.sendConfirmation(context.getChunkedResponse());
                TextQueryProcessor.readyForNextRequest(context);
            }
            catch (ImplicitCastException | SqlException e) {
                this.syntaxError(context.getChunkedResponse(), state, (FlyweightMessageContainer)((Object)e));
                TextQueryProcessor.readyForNextRequest(context);
            }
            catch (CairoError | CairoException e) {
                this.internalError(context.getChunkedResponse(), context.getLastRequestBytesSent(), e, state);
                TextQueryProcessor.readyForNextRequest(context);
            }
        }
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        TextQueryProcessorState state = LV.get(context);
        if (state == null) {
            state = new TextQueryProcessorState(context);
            LV.set(context, state);
        }
        state.rnd = null;
        HttpChunkedResponse response = context.getChunkedResponse();
        if (this.parseUrl(response, context.getRequestHeader(), state)) {
            this.execute(context, state);
        } else {
            TextQueryProcessor.readyForNextRequest(context);
        }
    }

    @Override
    public void parkRequest(HttpConnectionContext context, boolean pausedQuery) {
        TextQueryProcessorState state = LV.get(context);
        if (state != null) {
            state.pausedQuery = pausedQuery;
            state.rnd = this.sqlExecutionContext.getRandom();
        }
    }

    @Override
    public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException, QueryPausedException {
        try {
            this.doResumeSend(context);
        }
        catch (CairoError | CairoException e) {
            TextQueryProcessorState state = LV.get(context);
            if (state != null) {
                this.logInternalError(e, state);
            }
            throw ServerDisconnectException.INSTANCE;
        }
    }

    private static boolean isExpUrl(Utf8Sequence tok) {
        if (tok.size() != 4) {
            return false;
        }
        int i = 0;
        return (tok.byteAt(i++) | 0x20) == 47 && (tok.byteAt(i++) | 0x20) == 101 && (tok.byteAt(i++) | 0x20) == 120 && (tok.byteAt(i) | 0x20) == 112;
    }

    private static void putGeoHashStringValue(HttpChunkedResponse response, long value, int type) {
        if (value == -1L) {
            response.putAscii("null");
        } else {
            int bitFlags = GeoHashes.getBitFlags(type);
            response.putAscii('\"');
            if (bitFlags < 0) {
                GeoHashes.appendCharsUnsafe(value, -bitFlags, response);
            } else {
                GeoHashes.appendBinaryStringUnsafe(value, bitFlags, response);
            }
            response.putAscii('\"');
        }
    }

    private static void putIPv4Value(HttpChunkedResponse response, Record rec, int col) {
        int ip = rec.getIPv4(col);
        if (ip != 0) {
            Numbers.intToIPv4Sink(response, ip);
        }
    }

    private static void putInterval(HttpChunkedResponse response, Record rec, int col) {
        Interval interval = rec.getInterval(col);
        if (!Interval.NULL.equals(interval)) {
            ((Utf8Sink)response.putQuote().put(interval)).putQuote();
        }
    }

    private static void putStringOrNull(HttpChunkedResponse response, CharSequence cs) {
        if (cs != null) {
            response.putQuote().escapeCsvStr(cs).putQuote();
        }
    }

    private static void putUuidOrNull(HttpChunkedResponse response, long lo, long hi) {
        if (Uuid.isNull(lo, hi)) {
            return;
        }
        Numbers.appendUuid(lo, hi, response);
    }

    private static void putVarcharOrNull(HttpChunkedResponse response, Utf8Sequence us) {
        if (us != null) {
            response.putQuote().escapeCsvStr(us).putQuote();
        }
    }

    private static void readyForNextRequest(HttpConnectionContext context) {
        LOG.debug().$("all sent [fd=").$(context.getFd()).$(", lastRequestBytesSent=").$(context.getLastRequestBytesSent()).$(", nCompletedRequests=").$(context.getNCompletedRequests() + 1).$(", totalBytesSent=").$(context.getTotalBytesSent()).I$();
    }

    private LogRecord critical(TextQueryProcessorState state) {
        return LOG.critical().$('[').$(state.getFd()).$("] ");
    }

    /*
     * Unable to fully structure code
     */
    private void doResumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, QueryPausedException {
        state = TextQueryProcessor.LV.get(context);
        if (state == null) {
            return;
        }
        this.sqlExecutionContext.with(context.getSecurityContext(), null, state.rnd, context.getFd(), this.circuitBreaker.of(context.getFd()));
        TextQueryProcessor.LOG.debug().$("resume [fd=").$(context.getFd()).I$();
        if (!state.pausedQuery) {
            context.resumeResponseSend();
        } else {
            state.pausedQuery = false;
        }
        response = context.getChunkedResponse();
        metadata = state.recordCursorFactory.getMetadata();
        columnCount = metadata.getColumnCount();
        block11: while (true) {
            try {
                switch (state.queryState) {
                    case 0: {
                        state.hasNext = state.cursor.hasNext();
                        this.header(response, state, 200);
                        state.queryState = 2;
                    }
                    case 2: {
                        if (!state.noMeta) {
                            state.columnIndex = 0;
                            while (state.columnIndex < columnCount) {
                                if (state.columnIndex > 0) {
                                    response.putAscii(state.delimiter);
                                }
                                response.putQuote().escapeCsvStr(metadata.getColumnName(state.columnIndex)).putQuote();
                                ++state.columnIndex;
                                response.bookmark();
                            }
                            response.putEOL();
                        }
                        state.queryState = 4;
                        response.bookmark();
                    }
                    case 4: {
                        if (state.record != null) ** GOTO lbl48
                        record = state.cursor.getRecord();
                        while (state.hasNext || state.cursor.hasNext()) {
                            state.hasNext = false;
                            ++state.count;
                            if (state.countRows && state.count > state.stop || state.count <= state.skip) continue;
                            state.record = record;
                            ** GOTO lbl48
                        }
                        state.queryState = 7;
                        continue block11;
lbl48:
                        // 2 sources

                        if (state.count > state.stop) {
                            state.queryState = 7;
                            continue block11;
                        }
                        state.queryState = 5;
                        state.columnIndex = 0;
                    }
                    case 5: {
                        while (state.columnIndex < columnCount) {
                            if (state.columnIndex > 0 && state.columnValueFullySent) {
                                response.putAscii(state.delimiter);
                            }
                            this.putValue(response, state);
                            ++state.columnIndex;
                            response.bookmark();
                        }
                        state.queryState = 6;
                    }
                    case 6: {
                        response.putEOL();
                        state.record = null;
                        state.queryState = 4;
                        response.bookmark();
                        continue block11;
                    }
                    case 7: {
                        state.cursor = Misc.free(state.cursor);
                        this.sendDone(response, state);
                        break;
                    }
                }
            }
            catch (DataUnavailableException e) {
                response.resetToBookmark();
                throw QueryPausedException.instance(e.getEvent(), this.sqlExecutionContext.getCircuitBreaker());
            }
            catch (NoSpaceLeftInResponseBufferException ignored) {
                if (response.resetToBookmark()) {
                    response.sendChunk(false);
                    continue;
                }
                this.info(state).$("Response buffer is too small, state=").$(state.queryState).$();
                throw PeerDisconnectedException.INSTANCE;
            }
            break;
        }
        TextQueryProcessor.readyForNextRequest(context);
    }

    private LogRecord error(TextQueryProcessorState state) {
        return LOG.error().$('[').$(state.getFd()).$("] ");
    }

    private LogRecord info(TextQueryProcessorState state) {
        return LOG.info().$('[').$(state.getFd()).$("] ");
    }

    private void internalError(HttpChunkedResponse response, long bytesSent, Throwable e, TextQueryProcessorState state) throws ServerDisconnectException, PeerDisconnectedException, PeerIsSlowToReadException {
        this.logInternalError(e, state);
        if (bytesSent > 0L) {
            throw ServerDisconnectException.INSTANCE;
        }
        this.sendException(response, 0, e.getMessage(), state);
    }

    private void logInternalError(Throwable e, TextQueryProcessorState state) {
        if (e instanceof CairoException) {
            CairoException ce = (CairoException)e;
            if (ce.isInterruption()) {
                this.info(state).$("query cancelled [reason=`").$safe(((CairoException)e).getFlyweightMessage()).$("`, q=`").$safe(state.query).$("`]").$();
            } else if (ce.isCritical()) {
                this.critical(state).$("error [msg=`").$safe(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$("`, q=`").$safe(state.query).$("`]").$();
            } else {
                this.error(state).$("error [msg=`").$safe(ce.getFlyweightMessage()).$("`, errno=").$(ce.getErrno()).$("`, q=`").$safe(state.query).$("`]").$();
            }
        } else if (e instanceof HttpException) {
            this.error(state).$("internal HTTP server error [reason=`").$safe(((HttpException)e).getFlyweightMessage()).$("`, q=`").$safe(state.query).$("`]").$();
        } else {
            this.critical(state).$("internal error [ex=").$(e).$(", q=`").$safe(state.query).$("`]").$();
            this.metrics.healthMetrics().incrementUnhandledErrors();
        }
    }

    private boolean parseUrl(HttpChunkedResponse response, HttpRequestHeader request, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        DirectUtf8Sequence query = request.getUrlParam(HttpConstants.URL_PARAM_QUERY);
        if (query == null || query.size() == 0) {
            this.info(state).$("Empty query request received. Sending empty reply.").$();
            this.sendException(response, 0, "No query text", state);
            return false;
        }
        long skip = 0L;
        long stop = Long.MAX_VALUE;
        DirectUtf8Sequence limit = request.getUrlParam(HttpConstants.URL_PARAM_LIMIT);
        if (limit != null) {
            int sepPos = Utf8s.indexOfAscii(limit, ',');
            try {
                if (sepPos > 0) {
                    skip = Numbers.parseLong(limit, 0, sepPos);
                    if (sepPos + 1 < limit.size()) {
                        stop = Numbers.parseLong(limit, sepPos + 1, limit.size());
                    }
                } else {
                    stop = Numbers.parseLong(limit);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        if (stop < 0L) {
            stop = 0L;
        }
        if (skip < 0L) {
            skip = 0L;
        }
        if (stop - skip > this.configuration.getMaxQueryResponseRowLimit()) {
            stop = skip + this.configuration.getMaxQueryResponseRowLimit();
        }
        state.query.clear();
        if (!Utf8s.utf8ToUtf16(query.lo(), query.hi(), state.query)) {
            this.info(state).$("Bad UTF8 encoding").$();
            this.sendException(response, 0, "Bad UTF8 encoding in query text", state);
            return false;
        }
        DirectUtf8Sequence fileName = request.getUrlParam(HttpConstants.URL_PARAM_FILENAME);
        state.fileName = null;
        if (fileName != null && fileName.size() > 0) {
            state.fileName = fileName.toString();
        }
        DirectUtf8Sequence delimiter = request.getUrlParam(HttpConstants.URL_PARAM_DELIMITER);
        state.delimiter = (char)44;
        if (delimiter != null && delimiter.size() == 1) {
            state.delimiter = (char)delimiter.byteAt(0);
        }
        state.skip = skip;
        state.count = 0L;
        state.stop = stop;
        state.noMeta = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_NM));
        state.countRows = HttpKeywords.isTrue(request.getUrlParam(HttpConstants.URL_PARAM_COUNT));
        return true;
    }

    private void putArrayValue(HttpChunkedResponse response, TextQueryProcessorState state, Record record, int columnIdx, int columnType) {
        state.arrayState.of(response);
        ArrayView arrayView = state.arrayState.getArrayView() == null ? record.getArray(columnIdx, columnType) : state.arrayState.getArrayView();
        try {
            state.arrayState.putCharIfNew(response, '\"');
            ArrayTypeDriver.arrayToJson(arrayView, response, state.arrayState);
            state.arrayState.putCharIfNew(response, '\"');
            state.arrayState.clear();
            state.columnValueFullySent = true;
        }
        catch (Throwable e) {
            state.columnValueFullySent = state.arrayState.isNothingWritten();
            state.arrayState.reset(arrayView);
            throw e;
        }
    }

    private void putValue(HttpChunkedResponse response, TextQueryProcessorState state) {
        int columnType = state.metadata.getColumnType(state.columnIndex);
        int columnIndex = state.columnIndex;
        Record rec = state.record;
        switch (ColumnType.tagOf(columnType)) {
            case 1: {
                response.put(rec.getBool(columnIndex));
                break;
            }
            case 2: {
                response.put((int)rec.getByte(columnIndex));
                break;
            }
            case 10: {
                double d = rec.getDouble(columnIndex);
                if (!Numbers.isFinite(d)) break;
                response.put(d);
                break;
            }
            case 9: {
                float f = rec.getFloat(columnIndex);
                if (!Numbers.isFinite(f)) break;
                response.put(f);
                break;
            }
            case 5: {
                int i = rec.getInt(columnIndex);
                if (i == Integer.MIN_VALUE) break;
                response.put(i);
                break;
            }
            case 6: {
                long l = rec.getLong(columnIndex);
                if (l == Long.MIN_VALUE) break;
                response.put(l);
                break;
            }
            case 7: {
                long l = rec.getDate(columnIndex);
                if (l == Long.MIN_VALUE) break;
                ((Utf8Sink)response.putAscii('\"').putISODateMillis(l)).putAscii('\"');
                break;
            }
            case 8: {
                long l = rec.getTimestamp(columnIndex);
                if (l == Long.MIN_VALUE) break;
                ((Utf8Sink)response.putAscii('\"').putISODate(l)).putAscii('\"');
                break;
            }
            case 3: {
                response.put(rec.getShort(columnIndex));
                break;
            }
            case 4: {
                char c = rec.getChar(columnIndex);
                if (c <= '\u0000') break;
                response.put(c);
                break;
            }
            case 18: 
            case 22: 
            case 33: {
                break;
            }
            case 11: {
                TextQueryProcessor.putStringOrNull(response, rec.getStrA(columnIndex));
                break;
            }
            case 26: {
                TextQueryProcessor.putVarcharOrNull(response, rec.getVarcharA(columnIndex));
                break;
            }
            case 12: {
                TextQueryProcessor.putStringOrNull(response, rec.getSymA(columnIndex));
                break;
            }
            case 13: {
                rec.getLong256(columnIndex, response);
                break;
            }
            case 14: {
                TextQueryProcessor.putGeoHashStringValue(response, rec.getGeoByte(columnIndex), columnType);
                break;
            }
            case 15: {
                TextQueryProcessor.putGeoHashStringValue(response, rec.getGeoShort(columnIndex), columnType);
                break;
            }
            case 16: {
                TextQueryProcessor.putGeoHashStringValue(response, rec.getGeoInt(columnIndex), columnType);
                break;
            }
            case 17: {
                TextQueryProcessor.putGeoHashStringValue(response, rec.getGeoLong(columnIndex), columnType);
                break;
            }
            case 19: {
                TextQueryProcessor.putUuidOrNull(response, rec.getLong128Lo(columnIndex), rec.getLong128Hi(columnIndex));
                break;
            }
            case 24: {
                throw new UnsupportedOperationException();
            }
            case 25: {
                TextQueryProcessor.putIPv4Value(response, rec, columnIndex);
                break;
            }
            case 32: {
                TextQueryProcessor.putInterval(response, rec, columnIndex);
                break;
            }
            case 27: {
                this.putArrayValue(response, state, rec, columnIndex, columnType);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void sendConfirmation(HttpChunkedResponse response) throws PeerDisconnectedException, PeerIsSlowToReadException {
        response.putAscii("DDL Success\n");
        response.sendChunk(true);
    }

    private void sendDone(HttpChunkedResponse response, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        if (state.count > -1L) {
            state.count = -1L;
            response.sendChunk(true);
            return;
        }
        response.done();
    }

    private void sendException(HttpChunkedResponse response, int position, CharSequence message, TextQueryProcessorState state) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.headerJsonError(response);
        JsonQueryProcessorState.prepareExceptionJson(response, position, message, state.query);
    }

    private void syntaxError(HttpChunkedResponse response, TextQueryProcessorState state, FlyweightMessageContainer container) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.info(state).$("syntax-error [q=`").$safe(state.query).$("`, at=").$(container.getPosition()).$(", message=`").$safe(container.getFlyweightMessage()).$('`').I$();
        this.sendException(response, container.getPosition(), container.getFlyweightMessage(), state);
    }

    protected void header(HttpChunkedResponse response, TextQueryProcessorState state, int statusCode) throws PeerDisconnectedException, PeerIsSlowToReadException {
        response.status(statusCode, "text/csv; charset=utf-8");
        if (state.fileName != null && !state.fileName.isEmpty()) {
            response.headers().putAscii("Content-Disposition: attachment; filename=\"").put(state.fileName).putAscii(".csv\"").putEOL();
        } else {
            ((Utf8Sink)response.headers().putAscii("Content-Disposition: attachment; filename=\"questdb-query-").put(this.clock.getTicks())).putAscii(".csv\"").putEOL();
        }
        response.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        response.sendHeader();
    }

    protected void headerJsonError(HttpChunkedResponse response) throws PeerDisconnectedException, PeerIsSlowToReadException {
        response.status(400, "application/json; charset=utf-8");
        response.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        response.sendHeader();
    }

    protected void headerNoContentDisposition(HttpChunkedResponse response) throws PeerDisconnectedException, PeerIsSlowToReadException {
        response.status(200, "text/csv; charset=utf-8");
        response.headers().setKeepAlive(this.configuration.getKeepAliveHeader());
        response.sendHeader();
    }
}

