/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class HttpClientException
extends RuntimeException {
    private final StringSink message = new StringSink();
    private int errno = Integer.MIN_VALUE;

    public HttpClientException(String message) {
        this.message.put(message);
    }

    public HttpClientException errno(int errno) {
        this.errno = errno;
        return this;
    }

    @Override
    public String getMessage() {
        if (this.errno == Integer.MIN_VALUE) {
            return this.message.toString();
        }
        String errNoRender = "[" + this.errno + "]";
        if (this.message.length() == 0) {
            return errNoRender;
        }
        return errNoRender + " " + String.valueOf(this.message);
    }

    public HttpClientException put(char value) {
        this.message.put(value);
        return this;
    }

    public HttpClientException put(int value) {
        this.message.put(value);
        return this;
    }

    public HttpClientException put(long value) {
        this.message.put(value);
        return this;
    }

    public HttpClientException put(@Nullable CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public HttpClientException putSize(long value) {
        this.message.putSize(value);
        return this;
    }
}

