/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpAuthenticator;
import io.questdb.cutlass.http.HttpAuthenticatorFactory;
import io.questdb.cutlass.http.StaticHttpAuthenticator;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.str.Utf8StringSink;

public class StaticHttpAuthenticatorFactory
implements HttpAuthenticatorFactory {
    private final StaticHttpAuthenticator authenticator;

    public StaticHttpAuthenticatorFactory(String username, String password) {
        BinarySequenceAdapter binarySequenceAdapter = new BinarySequenceAdapter();
        binarySequenceAdapter.put(username).colon().put(password);
        Utf8StringSink expectedHeader = new Utf8StringSink();
        expectedHeader.put("Basic ");
        Chars.base64Encode(binarySequenceAdapter, (int)binarySequenceAdapter.length(), expectedHeader);
        this.authenticator = new StaticHttpAuthenticator(username, expectedHeader);
    }

    @Override
    public HttpAuthenticator getHttpAuthenticator() {
        return this.authenticator;
    }

    private static class BinarySequenceAdapter
    implements BinarySequence,
    Mutable {
        private final Utf8StringSink baseSink = new Utf8StringSink();

        private BinarySequenceAdapter() {
        }

        @Override
        public byte byteAt(long index) {
            return this.baseSink.byteAt((int)index);
        }

        @Override
        public void clear() {
            this.baseSink.clear();
        }

        @Override
        public long length() {
            return this.baseSink.size();
        }

        BinarySequenceAdapter colon() {
            this.baseSink.putAscii(':');
            return this;
        }

        BinarySequenceAdapter put(CharSequence value) {
            this.baseSink.put(value);
            return this;
        }
    }
}

