/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpException;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MimeTypesCache
extends Utf8SequenceObjHashMap<CharSequence> {
    public MimeTypesCache(InputStream inputStream) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = reader.readLine().trim();
            String regex = "\\t+";
            Pattern pattern = Pattern.compile(regex);
            while (line != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') {
                    Matcher matcher = pattern.matcher(line);
                    String l = matcher.replaceAll("\t");
                    String[] tuple = l.split("\t");
                    String type = tuple[0].trim();
                    String[] suffixTuple = tuple[1].split(" ");
                    int n = suffixTuple.length;
                    for (int i = 0; i < n; ++i) {
                        Utf8String s = new Utf8String(suffixTuple[i].trim());
                        this.put(s, type);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeTypesCache(FilesFacade ff, LPSZ path) {
        long fd = ff.openRO(path);
        if (fd < 0L) {
            throw HttpException.instance("could not open [file=").put(path).put(", errno=").put(ff.errno()).put(']');
        }
        long fileSize = ff.length(fd);
        if (fileSize < 1L || fileSize > 0x100000L) {
            ff.close(fd);
            throw HttpException.instance("wrong file size [file=").put(path).put(", size=").put(fileSize).put(']');
        }
        long buffer = Unsafe.malloc(fileSize, 33);
        long read = ff.read(fd, buffer, fileSize, 0L);
        try {
            if (read != fileSize) {
                Unsafe.free(buffer, fileSize, 33);
                throw HttpException.instance("could not read [file=").put(path).put(", size=").put(fileSize).put(", read=").put(read).put(", errno=").put(ff.errno()).put(']');
            }
        }
        finally {
            ff.close(fd);
        }
        DirectUtf8String dus = new DirectUtf8String();
        try {
            long p = buffer;
            long hi = p + fileSize;
            long _lo = p;
            boolean newline = true;
            boolean comment = false;
            String contentType = null;
            block11: while (p < hi) {
                char b = (char)Unsafe.getUnsafe().getByte(p++);
                switch (b) {
                    case '#': {
                        comment = newline;
                        break;
                    }
                    case '\t': 
                    case ' ': {
                        if (comment) continue block11;
                        if (newline || _lo == p - 1L) {
                            _lo = p;
                            break;
                        }
                        Utf8String s = Utf8String.newInstance(dus.of(_lo, p - 1L));
                        _lo = p;
                        if (contentType == null) {
                            contentType = Utf8s.toString(s);
                            break;
                        }
                        this.put(s, contentType);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        Utf8String s;
                        newline = true;
                        comment = false;
                        if (_lo < p - 1L && contentType != null) {
                            s = Utf8String.newInstance(dus.of(_lo, p - 1L));
                            this.put(s, contentType);
                        }
                        contentType = null;
                        _lo = p;
                        break;
                    }
                    default: {
                        if (!newline) continue block11;
                        newline = false;
                    }
                }
            }
            if (contentType != null && _lo < p) {
                Utf8String s = Utf8String.newInstance(dus.of(_lo, p));
                this.put(s, contentType);
            }
        }
        finally {
            Unsafe.free(buffer, fileSize, 33);
        }
    }
}

