/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class WalEventReader
implements Closeable {
    private final WalEventCursor eventCursor;
    private final MemoryCMR eventIndexMem;
    private final MemoryCMR eventMem;
    private final FilesFacade ff;

    public WalEventReader(FilesFacade ff) {
        this.ff = ff;
        this.eventIndexMem = Vm.getCMRInstance();
        this.eventMem = Vm.getCMRInstance();
        this.eventCursor = new WalEventCursor(this.eventMem);
    }

    @Override
    public void close() {
        Misc.free(this.eventIndexMem);
        Misc.free(this.eventMem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalEventCursor of(Path path, long segmentTxn) {
        int trimTo = path.size();
        try {
            int pathLen = path.size();
            path.concat("_event");
            this.eventMem.of(this.ff, path.$(), this.ff.getPageSize(), 12L, 10, 0, -1);
            if (segmentTxn > -1L) {
                int maxTxn = this.eventMem.getInt(0L);
                if (maxTxn < -1) {
                    boolean errno = false;
                    throw CairoException.critical(0).put("segment ").put(path).put(" does not have a valid maxTxn: ").put(maxTxn);
                }
                long fullEventIndexMapSize = ((long)maxTxn + 2L) * 8L;
                long minEventIndexMapSize = (segmentTxn + 2L) * 8L;
                try {
                    this.eventIndexMem.of(this.ff, path.trimTo(pathLen).concat("_event.i").$(), this.ff.getPageSize(), fullEventIndexMapSize, 10, 0, Files.POSIX_MADV_RANDOM);
                }
                catch (CairoException _couldNotMapToMaxTxn) {
                    this.eventIndexMem.of(this.ff, path.trimTo(pathLen).concat("_event.i").$(), this.ff.getPageSize(), minEventIndexMapSize, 10, 0, Files.POSIX_MADV_RANDOM);
                }
                try {
                    long offset = WalEventReader.readNonNegativeLong(this.eventIndexMem, segmentTxn * 8L);
                    long size = WalEventReader.readNonNegativeLong(this.eventIndexMem, ((long)maxTxn + 1L) * 8L);
                    if (offset >= 8L && size < 12L) {
                        size = WalEventReader.readNonNegativeLong(this.eventIndexMem, (segmentTxn + 1L) * 8L);
                    }
                    if (offset < 8L || size < 12L || offset >= size) {
                        int errno = offset < 0L || size < 0L ? this.ff.errno() : 0;
                        long fileSize = this.ff.length(this.eventMem.getFd());
                        throw CairoException.critical(errno).put("segment ").put(path).put(" does not have txn with id ").put(segmentTxn).put(", offset=").put(offset).put(", indexFileSize=").put(fileSize).put(", maxTxn=").put(maxTxn).put(", size=").put(size);
                    }
                    long eventMapSize = size + 4L;
                    this.eventMem.extend(eventMapSize);
                    this.eventCursor.openOffset(offset);
                }
                finally {
                    Misc.free(this.eventIndexMem);
                }
            }
            this.eventCursor.openOffset(-1L);
            int version = this.eventMem.getInt(4L);
            short formatVersion = Numbers.decodeLowShort(version);
            if (formatVersion != 0 && formatVersion != 1) {
                throw TableUtils.validationException(this.eventMem).put("WAL events file version does not match runtime version [expected=").put(0L).put(" or ").put(1L).put(", actual=").put(formatVersion).put(']');
            }
            WalEventCursor walEventCursor = this.eventCursor;
            return walEventCursor;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(trimTo);
        }
    }

    private static long readNonNegativeLong(MemoryCMR eventIndexMem, long offset) {
        if (offset < 0L || offset + 8L > eventIndexMem.size()) {
            return -1L;
        }
        return eventIndexMem.getLong(offset);
    }
}

