/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.MapValueMergeFunction;
import io.questdb.cairo.map.Unordered4MapCursor;
import io.questdb.cairo.map.Unordered4MapRecord;
import io.questdb.cairo.map.Unordered4MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Hash;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Unordered4Map
implements Map,
Reopenable {
    static final long KEY_SIZE = 4L;
    private static final long MAX_SAFE_INT_POW_2 = 0x80000000L;
    private static final int MIN_KEY_CAPACITY = 16;
    private final Unordered4MapCursor cursor;
    private final long entrySize;
    private final Key key;
    private final double loadFactor;
    private final int maxResizes;
    private final int memoryTag;
    private final Unordered4MapRecord record;
    private final Unordered4MapValue value;
    private final Unordered4MapValue value2;
    private final Unordered4MapValue value3;
    private int free;
    private boolean hasZero;
    private int initialKeyCapacity;
    private int keyCapacity;
    private long keyMemStart;
    private long mask;
    private long memLimit;
    private long memStart;
    private int nResizes;
    private int size = 0;
    private long zeroMemStart;

    public Unordered4Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, 60);
    }

    Unordered4Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag) {
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        try {
            this.memoryTag = memoryTag;
            this.loadFactor = loadFactor;
            this.keyCapacity = (int)((double)keyCapacity / loadFactor);
            this.keyCapacity = this.initialKeyCapacity = Math.max(Numbers.ceilPow2(this.keyCapacity), 16);
            this.maxResizes = maxResizes;
            this.mask = this.keyCapacity - 1;
            this.free = (int)((double)this.keyCapacity * loadFactor);
            this.nResizes = 0;
            int keyColumnCount = keyTypes.getColumnCount();
            long keySize = 0L;
            for (int i = 0; i < keyColumnCount; ++i) {
                int columnType = keyTypes.getColumnType(i);
                int size = ColumnType.sizeOf(columnType);
                if (size > 0) {
                    keySize += (long)size;
                    continue;
                }
                keySize = -1L;
                break;
            }
            if (keySize <= 0L || keySize > 4L) {
                throw CairoException.nonCritical().put("unexpected key size: ").put(keySize);
            }
            long valueOffset = 0L;
            long[] valueOffsets = null;
            long valueSize = 0L;
            if (valueTypes != null) {
                int valueColumnCount = valueTypes.getColumnCount();
                valueOffsets = new long[valueColumnCount];
                for (int i = 0; i < valueColumnCount; ++i) {
                    valueOffsets[i] = valueOffset;
                    int columnType = valueTypes.getColumnType(i);
                    int size = ColumnType.sizeOf(columnType);
                    if (size <= 0) {
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                    valueOffset += (long)size;
                    valueSize += (long)size;
                }
            }
            this.entrySize = Bytes.align4b(4L + valueSize);
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = Unsafe.malloc(sizeBytes, memoryTag);
            Vect.memset(this.memStart, sizeBytes, 0);
            this.memLimit = this.memStart + sizeBytes;
            this.keyMemStart = Unsafe.malloc(4L, memoryTag);
            Unsafe.getUnsafe().putInt(this.keyMemStart, 0);
            this.zeroMemStart = Unsafe.malloc(this.entrySize, memoryTag);
            Vect.memset(this.zeroMemStart, this.entrySize, 0);
            this.value = new Unordered4MapValue(valueSize, valueOffsets);
            this.value2 = new Unordered4MapValue(valueSize, valueOffsets);
            this.value3 = new Unordered4MapValue(valueSize, valueOffsets);
            this.record = new Unordered4MapRecord(valueSize, valueOffsets, this.value, keyTypes, valueTypes);
            this.cursor = new Unordered4MapCursor(this.record, this);
            this.key = new Key();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.nResizes = 0;
        this.hasZero = false;
        Vect.memset(this.memStart, this.memLimit - this.memStart, 0);
        Unsafe.getUnsafe().putInt(this.keyMemStart, 0);
        Vect.memset(this.zeroMemStart, this.entrySize, 0);
    }

    @Override
    public void close() {
        if (this.memStart != 0L) {
            this.memLimit = this.memStart = Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
            this.keyMemStart = Unsafe.free(this.keyMemStart, 4L, this.memoryTag);
            this.zeroMemStart = Unsafe.free(this.zeroMemStart, this.entrySize, this.memoryTag);
            this.free = 0;
            this.size = 0;
            this.hasZero = false;
        }
    }

    @Override
    public MapRecordCursor getCursor() {
        if (this.hasZero) {
            return this.cursor.init(this.memStart, this.memLimit, this.zeroMemStart, this.size + 1);
        }
        return this.cursor.init(this.memStart, this.memLimit, 0L, this.size);
    }

    @Override
    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public boolean isOpen() {
        return this.memStart != 0L;
    }

    @Override
    public void merge(Map srcMap, MapValueMergeFunction mergeFunc) {
        assert (this != srcMap);
        long srcSize = srcMap.size();
        if (srcSize == 0L) {
            return;
        }
        Unordered4Map src4Map = (Unordered4Map)srcMap;
        if (src4Map.hasZero) {
            if (this.hasZero) {
                mergeFunc.merge(this.valueAt(this.zeroMemStart), src4Map.valueAt(src4Map.zeroMemStart));
            } else {
                Vect.memcpy(this.zeroMemStart, src4Map.zeroMemStart, this.entrySize);
                this.hasZero = true;
            }
            if (srcSize == 1L) {
                return;
            }
        }
        block0: for (long srcAddr = src4Map.memStart; srcAddr < src4Map.memLimit; srcAddr += this.entrySize) {
            int k;
            int key = Unsafe.getUnsafe().getInt(srcAddr);
            if (key == 0) continue;
            long destAddr = this.getStartAddress(Hash.hashInt64(key) & this.mask);
            while ((k = Unsafe.getUnsafe().getInt(destAddr)) != 0) {
                if (k == key) {
                    mergeFunc.merge(this.valueAt(destAddr), src4Map.valueAt(srcAddr));
                    continue block0;
                }
                destAddr = this.getNextAddress(destAddr);
            }
            Vect.memcpy(destAddr, srcAddr, this.entrySize);
            ++this.size;
            if (--this.free != 0) continue;
            this.rehash();
        }
    }

    @Override
    public void reopen(int keyCapacity, long heapSize) {
        if (this.memStart == 0L) {
            keyCapacity = (int)((double)keyCapacity / this.loadFactor);
            this.initialKeyCapacity = Math.max(Numbers.ceilPow2(keyCapacity), 16);
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void reopen() {
        if (this.memStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        if (this.memStart == 0L || this.keyCapacity != this.initialKeyCapacity) {
            this.keyCapacity = this.initialKeyCapacity;
            this.mask = this.keyCapacity - 1;
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = this.memStart == 0L ? Unsafe.malloc(sizeBytes, this.memoryTag) : Unsafe.realloc(this.memStart, this.memLimit - this.memStart, sizeBytes, this.memoryTag);
            this.memLimit = this.memStart + sizeBytes;
        }
        if (this.keyMemStart == 0L) {
            this.keyMemStart = Unsafe.malloc(4L, this.memoryTag);
        }
        if (this.zeroMemStart == 0L) {
            this.zeroMemStart = Unsafe.malloc(this.entrySize, this.memoryTag);
        }
        this.clear();
    }

    @Override
    public void setKeyCapacity(int newKeyCapacity) {
        long requiredCapacity = (long)((double)newKeyCapacity / this.loadFactor);
        if (requiredCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        this.rehash(Numbers.ceilPow2((int)requiredCapacity));
    }

    @Override
    public long size() {
        return this.hasZero ? (long)(this.size + 1) : (long)this.size;
    }

    @Override
    public MapValue valueAt(long startAddress) {
        return this.valueOf(startAddress, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private Unordered4MapValue asNew(long startAddress, int key, long hashCode, Unordered4MapValue value) {
        Unsafe.getUnsafe().putInt(startAddress, key);
        if (--this.free == 0) {
            int k;
            this.rehash();
            startAddress = this.getStartAddress(hashCode & this.mask);
            while ((k = Unsafe.getUnsafe().getInt(startAddress)) != key) {
                startAddress = this.getNextAddress(startAddress);
            }
        }
        ++this.size;
        return this.valueOf(startAddress, true, value);
    }

    private long getNextAddress(long entryAddress) {
        if ((entryAddress += this.entrySize) < this.memLimit) {
            return entryAddress;
        }
        return this.memStart;
    }

    private long getStartAddress(long memStart, long index) {
        return memStart + this.entrySize * index;
    }

    private long getStartAddress(long index) {
        return this.getStartAddress(this.memStart, index);
    }

    private Unordered4MapValue probe0(int key, long startAddress, long hashCode, Unordered4MapValue value) {
        int k;
        do {
            startAddress = this.getNextAddress(startAddress);
            k = Unsafe.getUnsafe().getInt(startAddress);
            if (k != 0) continue;
            return this.asNew(startAddress, key, hashCode, value);
        } while (k != key);
        return this.valueOf(startAddress, false, value);
    }

    private Unordered4MapValue probeReadOnly(int key, long startAddress, Unordered4MapValue value) {
        int k;
        do {
            startAddress = this.getNextAddress(startAddress);
            k = Unsafe.getUnsafe().getInt(startAddress);
            if (k != 0) continue;
            return null;
        } while (k != key);
        return this.valueOf(startAddress, false, value);
    }

    private void rehash() {
        this.rehash((long)this.keyCapacity << 1);
    }

    private void rehash(long newKeyCapacity) {
        if (this.nResizes == this.maxResizes) {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in unordered map");
        }
        if (newKeyCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        if (newKeyCapacity <= (long)this.keyCapacity) {
            return;
        }
        long newSizeBytes = this.entrySize * newKeyCapacity;
        long newMemStart = Unsafe.malloc(newSizeBytes, this.memoryTag);
        long newMemLimit = newMemStart + newSizeBytes;
        Vect.memset(newMemStart, newSizeBytes, 0);
        int newMask = (int)newKeyCapacity - 1;
        for (long addr = this.memStart; addr < this.memLimit; addr += this.entrySize) {
            int key = Unsafe.getUnsafe().getInt(addr);
            if (key == 0) continue;
            long newAddr = this.getStartAddress(newMemStart, Hash.hashInt64(key) & (long)newMask);
            while (Unsafe.getUnsafe().getInt(newAddr) != 0) {
                if ((newAddr += this.entrySize) < newMemLimit) continue;
                newAddr = newMemStart;
            }
            Vect.memcpy(newAddr, addr, this.entrySize);
        }
        Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
        this.memStart = newMemStart;
        this.memLimit = newMemStart + newSizeBytes;
        this.mask = newMask;
        this.free += (int)((double)(newKeyCapacity - (long)this.keyCapacity) * this.loadFactor);
        this.keyCapacity = (int)newKeyCapacity;
        ++this.nResizes;
    }

    private Unordered4MapValue valueOf(long startAddress, boolean newValue, Unordered4MapValue value) {
        return value.of(startAddress, this.memLimit, newValue);
    }

    long entrySize() {
        return this.entrySize;
    }

    boolean isZeroKey(long startAddress) {
        return Unsafe.getUnsafe().getInt(startAddress) == 0;
    }

    class Key
    implements MapKey {
        protected long appendAddress;

        Key() {
        }

        @Override
        public long commit() {
            assert (this.appendAddress <= Unordered4Map.this.keyMemStart + 4L);
            return 4L;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            Key src4Key = (Key)srcKey;
            this.copyFromRawKey(src4Key.startAddress());
        }

        @Override
        public MapValue createValue() {
            int key = Unsafe.getUnsafe().getInt(Unordered4Map.this.keyMemStart);
            if (key == 0) {
                return this.createZeroKeyValue();
            }
            return this.createNonZeroKeyValue(key, Hash.hashInt64(key));
        }

        @Override
        public MapValue createValue(long hashCode) {
            int key = Unsafe.getUnsafe().getInt(Unordered4Map.this.keyMemStart);
            if (key == 0) {
                return this.createZeroKeyValue();
            }
            return this.createNonZeroKeyValue(key, hashCode);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(Unordered4Map.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(Unordered4Map.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(Unordered4Map.this.value3);
        }

        @Override
        public long hash() {
            return Hash.hashInt64(Unsafe.getUnsafe().getInt(Unordered4Map.this.keyMemStart));
        }

        public Key init() {
            this.appendAddress = Unordered4Map.this.keyMemStart;
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public void putArray(ArrayView view) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putFloat(float value) {
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putIPv4(int value) {
            this.putInt(value);
        }

        @Override
        public void putInt(int value) {
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInterval(Interval interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong128(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(Long256 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putShort(short value) {
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skip(int bytes) {
            this.appendAddress += (long)bytes;
        }

        private MapValue createNonZeroKeyValue(int key, long hashCode) {
            long index = hashCode & Unordered4Map.this.mask;
            long startAddress = Unordered4Map.this.getStartAddress(index);
            int k = Unsafe.getUnsafe().getInt(startAddress);
            if (k == 0) {
                return Unordered4Map.this.asNew(startAddress, key, hashCode, Unordered4Map.this.value);
            }
            if (k == key) {
                return Unordered4Map.this.valueOf(startAddress, false, Unordered4Map.this.value);
            }
            return Unordered4Map.this.probe0(key, startAddress, hashCode, Unordered4Map.this.value);
        }

        private MapValue createZeroKeyValue() {
            if (Unordered4Map.this.hasZero) {
                return Unordered4Map.this.valueOf(Unordered4Map.this.zeroMemStart, false, Unordered4Map.this.value);
            }
            Unordered4Map.this.hasZero = true;
            return Unordered4Map.this.valueOf(Unordered4Map.this.zeroMemStart, true, Unordered4Map.this.value);
        }

        private MapValue findValue(Unordered4MapValue value) {
            int key = Unsafe.getUnsafe().getInt(Unordered4Map.this.keyMemStart);
            if (key == 0) {
                return Unordered4Map.this.hasZero ? Unordered4Map.this.valueOf(Unordered4Map.this.zeroMemStart, false, value) : null;
            }
            long hashCode = Hash.hashInt64(key);
            long index = hashCode & Unordered4Map.this.mask;
            long startAddress = Unordered4Map.this.getStartAddress(index);
            int k = Unsafe.getUnsafe().getInt(startAddress);
            if (k == 0) {
                return null;
            }
            if (k == key) {
                return Unordered4Map.this.valueOf(startAddress, false, value);
            }
            return Unordered4Map.this.probeReadOnly(key, startAddress, value);
        }

        void copyFromRawKey(long srcPtr) {
            int srcKey = Unsafe.getUnsafe().getInt(srcPtr);
            Unsafe.getUnsafe().putInt(this.appendAddress, srcKey);
            this.appendAddress += 4L;
        }

        long startAddress() {
            return Unordered4Map.this.keyMemStart;
        }
    }
}

