/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.BorrowedFlatArrayView;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.QuietCloseable;

public abstract class ArrayView
implements QuietCloseable {
    public static final int DIM_MAX_LEN = 0xFFFFFFF;
    protected final IntList shape = new IntList(0);
    protected final IntList strides = new IntList(0);
    protected FlatArrayView flatView;
    protected int flatViewLength;
    protected int flatViewOffset;
    protected boolean isVanilla = true;
    protected int type = 0;

    public final void appendDataToMem(MemoryA mem) {
        if (this.isNull() || this.isEmpty()) {
            return;
        }
        if (this.isVanilla) {
            this.flatView.appendToMemFlat(mem, this.flatViewOffset, this.flatViewLength);
        } else {
            this.appendToMemRecursive(0, 0, mem);
        }
    }

    public final void appendShapeToMem(MemoryA mem) {
        int dim = this.getDimCount();
        for (int i = 0; i < dim; ++i) {
            mem.putInt(this.getDimLen(i));
        }
    }

    public final boolean arrayEquals(ArrayView other) {
        if (this.type != other.type || this.shapeDiffers(other)) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (this.isVanilla && other.isVanilla) {
            FlatArrayView flatViewLeft = this.flatView;
            FlatArrayView flatViewRight = other.flatView;
            int length = this.flatViewLength;
            if (length != other.flatViewLength) {
                return false;
            }
            switch (this.getElemType()) {
                case 10: {
                    for (int i = 0; i < length; ++i) {
                        if (Numbers.equals(flatViewLeft.getDoubleAtAbsIndex(this.flatViewOffset + i), flatViewRight.getDoubleAtAbsIndex(other.flatViewOffset + i))) continue;
                        return false;
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < length; ++i) {
                        if (flatViewLeft.getLongAtAbsIndex(this.flatViewOffset + i) == flatViewRight.getLongAtAbsIndex(other.flatViewOffset + i)) continue;
                        return false;
                    }
                    break;
                }
                case 33: {
                    return true;
                }
                default: {
                    throw new UnsupportedOperationException("Implemented only for DOUBLE and LONG");
                }
            }
            return true;
        }
        return this.arrayEqualsRecursive(0, 0, other, 0);
    }

    public final int binarySearchDoubleValue1DArray(double value, boolean forwardScan) {
        double last;
        boolean ascending;
        if (this.isNull() || this.isEmpty()) {
            return 0;
        }
        int stride = this.getStride(0);
        int low = 0;
        int high = this.getDimLen(0) - 1;
        if (low > high) {
            return 0;
        }
        double first = this.getDouble(low);
        boolean bl = ascending = first <= (last = this.getDouble(high * stride));
        if (this.isVanilla) {
            return this.flatView.binarySearchDouble(value, this.flatViewOffset, this.flatViewLength, ascending, forwardScan);
        }
        while (low <= high) {
            int mid = low + (high - low) / 2;
            double midVal = this.getDouble(mid * stride);
            if (Math.abs(midVal - value) <= 1.0E-10) {
                if (forwardScan) {
                    while (low < mid) {
                        int m = low + (mid - low) / 2;
                        if (Math.abs(this.getDouble(m * stride) - value) <= 1.0E-10) {
                            mid = m;
                            continue;
                        }
                        low = m + 1;
                    }
                    return low;
                }
                while (mid < high) {
                    int m = mid + (high - mid + 1) / 2;
                    if (Math.abs(this.getDouble(m * stride) - value) <= 1.0E-10) {
                        mid = m;
                        continue;
                    }
                    high = m - 1;
                }
                return mid;
            }
            if (ascending) {
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
                continue;
            }
            if (midVal > value) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public final BorrowedFlatArrayView borrowedFlatView() {
        return (BorrowedFlatArrayView)this.flatView;
    }

    @Override
    public void close() {
    }

    public final FlatArrayView flatView() {
        return this.flatView;
    }

    public int getCardinality() {
        if (this.isVanilla) {
            return this.flatViewLength;
        }
        int cardinality = 1;
        for (int i = 0; i < this.shape.size(); ++i) {
            cardinality *= this.shape.getQuick(i);
        }
        return cardinality;
    }

    public final int getDimCount() {
        return ColumnType.decodeArrayDimensionality(this.type);
    }

    public final int getDimLen(int dimension) {
        assert (dimension >= 0 && dimension < this.shape.size());
        return this.shape.getQuick(dimension);
    }

    public final double getDouble(int flatIndex) {
        return this.flatView.getDoubleAtAbsIndex(this.flatViewOffset + flatIndex);
    }

    public final short getElemType() {
        return ColumnType.decodeArrayElementType(this.type);
    }

    public final int getFlatViewLength() {
        return this.flatViewLength;
    }

    public final int getFlatViewOffset() {
        return this.flatViewOffset;
    }

    public final int getHi() {
        return this.flatViewOffset + this.flatViewLength;
    }

    public final int getLo() {
        return this.flatViewOffset;
    }

    public final long getLong(int flatIndex) {
        return this.flatView.getLongAtAbsIndex(this.flatViewOffset + flatIndex);
    }

    public final int getStride(int dimension) {
        assert (dimension >= 0 && dimension < this.strides.size());
        return this.strides.getQuick(dimension);
    }

    public final int getType() {
        return this.type;
    }

    public final long getVanillaMemoryLayoutSize() {
        if (this.isNull()) {
            return 0L;
        }
        long elemSize = ColumnType.sizeOf(ColumnType.decodeArrayElementType(this.type));
        long intBytes = 4L;
        return intBytes + (long)this.getDimCount() * intBytes + (long)this.getCardinality() * elemSize;
    }

    public final boolean isEmpty() {
        for (int i = 0; i < this.shape.size(); ++i) {
            if (this.shape.getQuick(i) != 0) continue;
            return true;
        }
        return false;
    }

    public final boolean isNull() {
        return ColumnType.isNull(this.type);
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public final boolean shapeDiffers(ArrayView other) {
        int nDims = this.shape.size();
        IntList otherShape = other.shape;
        if (otherShape.size() != nDims) {
            return true;
        }
        for (int i = 0; i < nDims; ++i) {
            if (this.shape.getQuick(i) == otherShape.getQuick(i)) continue;
            return true;
        }
        return false;
    }

    public final String shapeToString() {
        return this.shape.toString();
    }

    private void appendToMemRecursive(int dim, int flatIndex, MemoryA mem) {
        block9: {
            int stride;
            int count;
            block8: {
                boolean atDeepestDim;
                short elemType = this.getElemType();
                assert (elemType == 10 || elemType == 6) : "implemented only for long and double";
                count = this.getDimLen(dim);
                stride = this.getStride(dim);
                boolean bl = atDeepestDim = dim == this.getDimCount() - 1;
                if (!atDeepestDim) break block8;
                switch (elemType) {
                    case 6: {
                        for (int i = 0; i < count; ++i) {
                            mem.putLong(this.getLong(flatIndex));
                            flatIndex += stride;
                        }
                        break block9;
                    }
                    case 10: {
                        for (int i = 0; i < count; ++i) {
                            mem.putDouble(this.getDouble(flatIndex));
                            flatIndex += stride;
                        }
                        break;
                    }
                }
                break block9;
            }
            for (int i = 0; i < count; ++i) {
                this.appendToMemRecursive(dim + 1, flatIndex, mem);
                flatIndex += stride;
            }
        }
    }

    private boolean arrayEqualsRecursive(int dim, int flatIndexThis, ArrayView other, int flatIndexOther) {
        boolean atDeepestDim;
        assert (ColumnType.isDouble(this.getElemType())) : "implemented only for double";
        int count = this.getDimLen(dim);
        int strideThis = this.getStride(dim);
        int strideOther = other.getStride(dim);
        boolean bl = atDeepestDim = dim == this.getDimCount() - 1;
        if (atDeepestDim) {
            for (int i = 0; i < count; ++i) {
                if (this.getDouble(flatIndexThis) != other.getDouble(flatIndexOther)) {
                    return false;
                }
                flatIndexThis += strideThis;
                flatIndexOther += strideOther;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (!this.arrayEqualsRecursive(dim + 1, flatIndexThis, other, flatIndexOther)) {
                    return false;
                }
                flatIndexThis += strideThis;
                flatIndexOther += strideOther;
            }
        }
        return true;
    }
}

