/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.QuietCloseable;

public class TableWriterSegmentCopyInfo
implements QuietCloseable {
    private final IntList seqTxnOrder = new IntList();
    private boolean allDataInOrder;
    private boolean hasSegmentGap;
    private long maxTimestamp = Long.MIN_VALUE;
    private long maxTxnRowCount;
    private long minTimestamp = Long.MAX_VALUE;
    private DirectLongList segments = new DirectLongList(4L, 56);
    private long startSeqTxn;
    private long totalRows;
    private DirectLongList txns = new DirectLongList(4L, 56);

    public void addSegment(int walId, int segmentId, long segmentLo, long segmentHi, boolean isLastSegmentUse) {
        this.segments.add(walId);
        this.segments.add(segmentId);
        this.segments.add(segmentLo);
        this.segments.add(isLastSegmentUse ? segmentHi : -segmentHi);
    }

    public void addTxn(long segmentRowOffset, int relativeSeqTxn, long committedRowsCount, int segmentIndex, long minTimestamp, long maxTimestamp) {
        this.txns.add(segmentRowOffset);
        this.txns.add(relativeSeqTxn);
        this.txns.add(committedRowsCount);
        this.txns.add(segmentIndex);
        if (this.seqTxnOrder.size() > 0) {
            this.seqTxnOrder.set(relativeSeqTxn, (int)(this.txns.size() / 4L - 1L));
        }
        this.maxTxnRowCount = Math.max(this.maxTxnRowCount, committedRowsCount);
        this.totalRows += committedRowsCount;
        this.minTimestamp = Math.min(this.minTimestamp, minTimestamp);
        this.maxTimestamp = Math.max(this.maxTimestamp, maxTimestamp);
    }

    public void clear() {
        this.segments.clear();
        this.txns.clear();
        this.seqTxnOrder.clear();
        this.totalRows = 0L;
        this.maxTxnRowCount = 0L;
        this.startSeqTxn = 0L;
        this.minTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        this.hasSegmentGap = false;
        this.allDataInOrder = false;
    }

    @Override
    public void close() {
        this.segments = Misc.free(this.segments);
        this.txns = Misc.free(this.txns);
    }

    public boolean getAllTxnDataInOrder() {
        return this.allDataInOrder;
    }

    public int getMappingOrder(long absoluteSeqTxn) {
        return this.seqTxnOrder.get((int)(absoluteSeqTxn - this.startSeqTxn));
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMaxTxRowCount() {
        return this.maxTxnRowCount;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getRowHi(int segmentIndex) {
        return Math.abs(this.segments.get((long)segmentIndex * 4L + 3L));
    }

    public long getRowLo(int segmentIndex) {
        return Math.abs(this.segments.get((long)segmentIndex * 4L + 2L));
    }

    public int getSegmentCount() {
        return (int)(this.segments.size() / 4L);
    }

    public int getSegmentId(int segmentIndex) {
        return (int)this.segments.get((long)segmentIndex * 4L + 1L);
    }

    public long getSegmentsAddress() {
        return this.segments.getAddress();
    }

    public long getStartTxn() {
        return this.startSeqTxn;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public long getTxnCount() {
        return this.txns.size() / 4L;
    }

    public long getTxnInfoAddress() {
        return this.txns.getAddress();
    }

    public int getWalId(int segmentIndex) {
        return (int)this.segments.get((long)segmentIndex * 4L);
    }

    public boolean hasSegmentGaps() {
        return this.hasSegmentGap;
    }

    public void initBlock(long startSeqTxn, int txnCount, boolean hasSymbols) {
        this.startSeqTxn = startSeqTxn;
        if (hasSymbols) {
            this.seqTxnOrder.setPos(txnCount);
        }
    }

    public boolean isLastSegmentUse(int segmentIndex) {
        return this.segments.get((long)segmentIndex * 4L + 3L) > 0L;
    }

    public void setAllTxnDataInOrder(boolean allInOrder) {
        this.allDataInOrder = allInOrder;
    }

    public void setSegmentGap(boolean value) {
        this.hasSegmentGap = value;
    }
}

