/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractTableNameRegistry;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.MetadataCacheWriter;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableToken;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public class TableNameRegistryRW
extends AbstractTableNameRegistry {
    public TableNameRegistryRW(CairoEngine engine, TableFlagResolver tableFlagResolver) {
        super(engine, tableFlagResolver);
        if (!this.nameStore.lock() && !engine.getConfiguration().getAllowTableRegistrySharedWrite()) {
            throw CairoException.critical(0).put("cannot lock table name registry file [path=").put(engine.getConfiguration().getDbRoot()).put(']');
        }
        this.tableNameToTableTokenMap = new ConcurrentHashMap(false);
        this.dirNameToTableTokenMap = new ConcurrentHashMap();
    }

    @Override
    public TableToken addTableAlias(String newName, TableToken tableToken) {
        TableToken newTableToken = tableToken.renamed(newName);
        TableToken oldToken = this.tableNameToTableTokenMap.putIfAbsent(newName, newTableToken);
        return oldToken == null ? newTableToken : null;
    }

    @Override
    public boolean dropTable(TableToken token) {
        assert (!TableNameRegistry.isLocked(token));
        ReverseTableMapItem reverseMapItem = (ReverseTableMapItem)this.dirNameToTableTokenMap.get(token.getDirName());
        if (reverseMapItem != null && this.tableNameToTableTokenMap.replace(token.getTableName(), token, LOCKED_DROP_TOKEN)) {
            if (token.isWal()) {
                this.nameStore.logDropTable(token);
                this.dirNameToTableTokenMap.put(token.getDirName(), ReverseTableMapItem.ofDropped(token));
            } else {
                this.dirNameToTableTokenMap.remove(token.getDirName(), reverseMapItem);
            }
            try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                metadataRW.dropTable(token);
            }
            boolean removed = this.tableNameToTableTokenMap.remove(token.getTableName(), LOCKED_DROP_TOKEN);
            assert (removed);
            return true;
        }
        return false;
    }

    @Override
    public TableToken lockTableName(String tableName, String dirName, int tableId, boolean isMatView, boolean isWal) {
        TableToken registeredRecord = this.tableNameToTableTokenMap.putIfAbsent(tableName, LOCKED_TOKEN);
        if (registeredRecord == null) {
            boolean isProtected = this.tableFlagResolver.isProtected(tableName);
            boolean isSystem = this.tableFlagResolver.isSystem(tableName);
            boolean isPublic = this.tableFlagResolver.isPublic(tableName);
            return new TableToken(tableName, dirName, tableId, isMatView, isWal, isSystem, isProtected, isPublic);
        }
        return null;
    }

    @Override
    public void purgeToken(TableToken token) {
        this.dirNameToTableTokenMap.remove(token.getDirName());
    }

    @Override
    public void registerName(TableToken tableToken) {
        String tableName = tableToken.getTableName();
        if (this.tableNameToTableTokenMap.get(tableName) != LOCKED_TOKEN) {
            throw CairoException.critical(0).put("cannot register table, name is not locked [name=").put(tableName).put(']');
        }
        try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
            metadataRW.hydrateTable(tableToken);
        }
        if (tableToken.isWal()) {
            this.nameStore.logAddTable(tableToken);
        }
        this.dirNameToTableTokenMap.put(tableToken.getDirName(), ReverseTableMapItem.of(tableToken));
        boolean stillLocked = this.tableNameToTableTokenMap.replace(tableName, LOCKED_TOKEN, tableToken);
        assert (stillLocked);
    }

    @Override
    public synchronized boolean reload(@Nullable ObjList<TableToken> convertedTables) {
        this.tableNameToTableTokenMap.clear();
        this.dirNameToTableTokenMap.clear();
        if (!this.nameStore.isLocked()) {
            this.nameStore.lock();
        }
        return this.nameStore.reload(this.tableNameToTableTokenMap, this.dirNameToTableTokenMap, convertedTables);
    }

    @Override
    public void removeAlias(TableToken tableToken) {
        this.tableNameToTableTokenMap.remove(tableToken.getTableName());
    }

    @Override
    public TableToken rename(CharSequence oldName, CharSequence newName, TableToken tableToken) {
        TableToken renamedTableToken;
        String newTableNameStr = Chars.toString(newName);
        if (this.tableNameToTableTokenMap.putIfAbsent(newTableNameStr, renamedTableToken = tableToken.renamed(newTableNameStr)) == null) {
            if (this.renameToNew(tableToken, renamedTableToken)) {
                return renamedTableToken;
            }
            this.tableNameToTableTokenMap.remove(newTableNameStr, renamedTableToken);
            throw CairoException.tableDoesNotExist(oldName);
        }
        throw CairoException.nonCritical().put("table '").put(newName).put("' already exists");
    }

    @Override
    public void rename(TableToken oldToken, TableToken newToken) {
        this.renameToNew(oldToken, newToken);
    }

    @Override
    public void unlockTableName(TableToken tableToken) {
        this.tableNameToTableTokenMap.remove(tableToken.getTableName(), LOCKED_TOKEN);
    }

    private boolean renameToNew(TableToken oldToken, TableToken newToken) {
        if (this.tableNameToTableTokenMap.replace(oldToken.getTableName(), oldToken, LOCKED_DROP_TOKEN)) {
            this.nameStore.logDropTable(oldToken);
            this.nameStore.logAddTable(newToken);
            try (MetadataCacheWriter metadataRW = this.engine.getMetadataCache().writeLock();){
                metadataRW.renameTable(oldToken, newToken);
            }
            this.dirNameToTableTokenMap.put(newToken.getDirName(), ReverseTableMapItem.of(newToken));
            boolean removed = this.tableNameToTableTokenMap.remove(oldToken.getTableName(), LOCKED_DROP_TOKEN);
            assert (removed);
            return true;
        }
        return false;
    }
}

