/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.api.MemoryMA;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class SymbolColumnIndexer
implements ColumnIndexer,
Mutable {
    private static final long SEQUENCE_OFFSET = Unsafe.getFieldOffset(SymbolColumnIndexer.class, "sequence");
    private final int bufferSize;
    private final BitmapIndexWriter writer;
    private long buffer;
    private long columnTop;
    private volatile boolean distressed = false;
    private long fd = -1L;
    private FilesFacade ff;
    private volatile long sequence = 0L;

    public SymbolColumnIndexer(CairoConfiguration configuration) {
        this.writer = new BitmapIndexWriter(configuration);
        this.bufferSize = 0x400000;
        this.buffer = Unsafe.malloc(this.bufferSize, 61);
    }

    @Override
    public void clear() {
        this.writer.clear();
    }

    @Override
    public void close() {
        this.releaseIndexWriter();
        if (this.buffer != 0L) {
            this.fd = -1L;
            Unsafe.free(this.buffer, this.bufferSize, 61);
            this.buffer = 0L;
        }
    }

    @Override
    public void configureFollowerAndWriter(Path path, CharSequence name, long columnNameTxn, MemoryMA columnMem, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(path, name, columnNameTxn);
            this.ff = columnMem.getFilesFacade();
            this.fd = columnMem.getFd();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void configureWriter(Path path, CharSequence name, long columnNameTxn, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(path, name, columnNameTxn);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void distress() {
        this.distressed = true;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public BitmapIndexWriter getWriter() {
        return this.writer;
    }

    @Override
    public void index(FilesFacade ff, long dataColumnFd, long loRow, long hiRow) {
        this.writer.rollbackConditionally(loRow);
        long lo = Math.max(loRow, this.columnTop);
        int bufferCount = (int)(((hiRow - lo) * 4L - 1L) / (long)this.bufferSize + 1L);
        for (int i = 0; i < bufferCount; ++i) {
            long fileOffset = (lo - this.columnTop) * 4L;
            long bytesToRead = Math.min((long)this.bufferSize, (hiRow - lo) * 4L);
            long read = ff.read(dataColumnFd, this.buffer, bytesToRead, fileOffset);
            if (read == -1L) {
                throw CairoException.critical(ff.errno()).put("could not read symbol column during indexing [fd=").put(dataColumnFd).put(", fileOffset=").put(fileOffset).put(", bytesToRead=").put(bytesToRead).put(']');
            }
            long pHi = this.buffer + read;
            long p = this.buffer;
            while (p < pHi) {
                this.writer.add(TableUtils.toIndexKey(Unsafe.getUnsafe().getInt(p)), lo);
                p += 4L;
                ++lo;
            }
        }
        this.writer.setMaxValue(hiRow - 1L);
    }

    @Override
    public boolean isDistressed() {
        return this.distressed;
    }

    @Override
    public void refreshSourceAndIndex(long loRow, long hiRow) {
        this.index(this.ff, this.fd, loRow, hiRow);
    }

    @Override
    public void releaseIndexWriter() {
        Misc.free(this.writer);
    }

    @Override
    public void rollback(long maxRow) {
        this.writer.rollbackValues(maxRow);
    }

    @Override
    public void sync(boolean async) {
        this.writer.sync(async);
    }

    @Override
    public boolean tryLock(long expectedSequence) {
        return Unsafe.cas((Object)this, SEQUENCE_OFFSET, expectedSequence, expectedSequence + 1L);
    }
}

