/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.component.validator.impl;

import java.util.List;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.manager.component.validator.ParamValidator;
import org.springframework.stereotype.Component;

@Component
public class OptionParamValidator
implements ParamValidator {
    @Override
    public boolean support(String type) {
        return "radio".equals(type) || "checkbox".equals(type);
    }

    @Override
    public void validate(ParamDefine paramDefine, Param param) {
        List options = paramDefine.getOptions();
        boolean invalid = true;
        if (options != null) {
            for (ParamDefine.Option option : options) {
                if (!param.getParamValue().equalsIgnoreCase(option.getValue())) continue;
                invalid = false;
                break;
            }
        }
        if (invalid) {
            throw new IllegalArgumentException("Params field " + paramDefine.getField() + " value " + param.getParamValue() + " is invalid option value");
        }
    }
}

