/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect;

import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.Ordering;
import org.apache.hadoop.hbase.shaded.org.apache.curator.shaded.com.google.common.collect.ParametricNullness;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ComparatorOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<T> comparator;
    private static final long serialVersionUID = 0L;

    ComparatorOrdering(Comparator<T> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public int compare(@ParametricNullness T a, @ParametricNullness T b) {
        return this.comparator.compare(a, b);
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ComparatorOrdering) {
            ComparatorOrdering that = (ComparatorOrdering)object;
            return this.comparator.equals(that.comparator);
        }
        return false;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return this.comparator.toString();
    }
}

