/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestSplitMergeQuotaTable {
    private static final Logger LOG = LoggerFactory.getLogger(TestSplitMergeQuotaTable.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSplitMergeQuotaTable.class);
    private final TableName tableName = QuotaUtil.QUOTA_TABLE_NAME;
    private final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setConfiguration(() -> {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.client.meta.operation.timeout", 1000);
        conf.setInt("hbase.client.retries.number", 2);
        configMap.forEach((arg_0, arg_1) -> ((Configuration)conf).set(arg_0, arg_1));
        return conf;
    }).build();
    @Rule
    public final RuleChain ruleChain;

    @Parameterized.Parameters(name="{1}")
    public static Object[][] params() {
        HashMap<String, String> quotasDisabledMap = new HashMap<String, String>();
        quotasDisabledMap.put("hbase.quota.enabled", "false");
        HashMap<String, String> quotasEnabledMap = new HashMap<String, String>();
        quotasEnabledMap.put("hbase.quota.enabled", "true");
        return new Object[][]{{quotasDisabledMap}, {quotasEnabledMap}};
    }

    public TestSplitMergeQuotaTable(Map<String, String> configMap) {
        ExternalResource ensureQuotaTableRule = new ExternalResource(){

            protected void before() throws Throwable {
                try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TestSplitMergeQuotaTable.this.miniClusterRule.getTestingUtility().getConfiguration()).get(30L, TimeUnit.SECONDS);){
                    AsyncAdmin admin = conn.getAdmin();
                    if (!((Boolean)admin.tableExists(QuotaUtil.QUOTA_TABLE_NAME).get(30L, TimeUnit.SECONDS)).booleanValue()) {
                        TestSplitMergeQuotaTable.this.miniClusterRule.getTestingUtility().getHBaseCluster().getMaster().createSystemTable((TableDescriptor)QuotaUtil.QUOTA_TABLE_DESC);
                    }
                }
            }
        };
        this.ruleChain = RuleChain.outerRule((TestRule)this.miniClusterRule).around((TestRule)ensureQuotaTableRule);
    }

    @Test
    public void testSplitMerge() throws Exception {
        HBaseTestingUtility util = this.miniClusterRule.getTestingUtility();
        util.waitTableAvailable(this.tableName, 30000L);
        try (AsyncConnection conn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)util.getConfiguration()).get(30L, TimeUnit.SECONDS);){
            final AsyncAdmin admin = conn.getAdmin();
            admin.split(this.tableName, Bytes.toBytes((int)16)).get(30L, TimeUnit.SECONDS);
            util.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return ((List)((CompletableFuture)admin.getRegions(TestSplitMergeQuotaTable.this.tableName).thenApply(val -> val.stream().filter(info -> info.getReplicaId() == 0).collect(Collectors.toList()))).get(30L, TimeUnit.SECONDS)).size() > 1;
                }

                public String explainFailure() {
                    return "Split has not finished yet";
                }
            });
            util.waitUntilNoRegionsInTransition();
            List regionInfos = (List)((CompletableFuture)admin.getRegions(this.tableName).thenApply(val -> val.stream().filter(info -> info.getReplicaId() == 0).collect(Collectors.toList()))).get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)regionInfos.size());
            LOG.info("{}", (Object)regionInfos);
            admin.mergeRegions(regionInfos.stream().map(RegionInfo::getRegionName).collect(Collectors.toList()), false).get(30L, TimeUnit.SECONDS);
            util.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return ((List)((CompletableFuture)admin.getRegions(TestSplitMergeQuotaTable.this.tableName).thenApply(val -> val.stream().filter(info -> info.getReplicaId() == 0).collect(Collectors.toList()))).get(30L, TimeUnit.SECONDS)).size() == 1;
                }

                public String explainFailure() {
                    return "Merge has not finished yet";
                }
            });
            Assert.assertEquals((long)1L, (long)((List)admin.getRegions(this.tableName).get(30L, TimeUnit.SECONDS)).size());
        }
    }
}

