/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.procedure.TestSCPBase;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
@RunWith(value=Parameterized.class)
public class TestHBCKSCP
extends TestSCPBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHBCKSCP.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBCKSCP.class);
    @Rule
    public TableNameTestRule tableNameTestRule = new TableNameTestRule();
    private final int replicas;
    private final HBCKSCPScheduler hbckscpScheduler;
    private final RegionSelector regionSelector;

    public TestHBCKSCP(int replicas, HBCKSCPScheduler hbckscpScheduler, RegionSelector regionSelector) {
        this.replicas = replicas;
        this.hbckscpScheduler = hbckscpScheduler;
        this.regionSelector = regionSelector;
    }

    @Parameterized.Parameters(name="replicas:{0} scheduler:{1} selector:{2}")
    public static Object[][] params() {
        return new Object[][]{{1, new ScheduleServerCrashProcedure(), new PrimaryNotMetaRegionSelector()}, {3, new ScheduleServerCrashProcedure(), new ReplicaNonMetaRegionSelector()}, {1, new ScheduleSCPsForUnknownServers(), new PrimaryNotMetaRegionSelector()}, {3, new ScheduleSCPsForUnknownServers(), new ReplicaNonMetaRegionSelector()}};
    }

    @Test
    public void test() throws Exception {
        int count;
        MiniHBaseCluster cluster = this.util.getHBaseCluster();
        Assert.assertEquals((long)3L, (long)cluster.getLiveRegionServerThreads().size());
        try (Table table = this.createTable(this.tableNameTestRule.getTableName());){
            this.util.loadTable(table, HBaseTestingUtility.COLUMNS[0]);
            count = this.util.countRows(table);
        }
        Assert.assertTrue((String)"expected some rows", (count > 0 ? 1 : 0) != 0);
        ServerName metaServer = this.util.getMiniHBaseCluster().getServerHoldingMeta();
        ServerName rsServerName = cluster.getRegionServerThreads().stream().map(JVMClusterUtil.RegionServerThread::getRegionServer).map(HRegionServer::getServerName).filter(sn -> !sn.equals((Object)metaServer)).findAny().orElseThrow(() -> new NoSuchElementException("Cannot locate a region server that is not hosting meta."));
        HMaster master = cluster.getMaster();
        List regions = master.getAssignmentManager().getRegionsOnServer(rsServerName);
        LOG.debug("{} is holding {} regions.", (Object)rsServerName, (Object)regions.size());
        RegionInfo rsRI = regions.stream().peek(info -> LOG.debug("{}", info)).filter(this.regionSelector::regionFilter).findAny().orElseThrow(this.regionSelector::regionFilterFailure);
        int replicaId = rsRI.getReplicaId();
        Result r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (RegionInfo)rsRI);
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getRegionStateColumn((int)replicaId))));
        ServerName serverName = MetaTableAccessor.getServerName((Result)r, (int)replicaId);
        Assert.assertEquals((Object)rsServerName, (Object)serverName);
        LOG.info("Killing {}", (Object)rsServerName);
        cluster.killRegionServer(rsServerName);
        master.getServerManager().moveFromOnlineToDeadServers(rsServerName);
        master.getServerManager().getDeadServers().finish(rsServerName);
        master.getServerManager().getDeadServers().removeDeadServer(rsServerName);
        master.getAssignmentManager().getRegionStates().removeServer(rsServerName);
        HRegionServer hrs = cluster.getRegionServer(rsServerName);
        this.util.waitFor(TimeUnit.MINUTES.toMillis(1L), () -> ((HRegionServer)hrs).isStopped());
        LOG.info("Dead {}", (Object)rsServerName);
        Assert.assertTrue((boolean)this.searchMeta(master, rsServerName));
        r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (RegionInfo)rsRI);
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getRegionStateColumn((int)replicaId))));
        serverName = MetaTableAccessor.getServerName((Result)r, (int)replicaId);
        TestCase.assertNotNull((Object)cluster.getRegionServer(serverName));
        Assert.assertEquals((Object)rsServerName, (Object)serverName);
        long pid = this.scheduleHBCKSCP(rsServerName, master);
        Assert.assertNotEquals((long)-1L, (long)pid);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)master.getMasterProcedureExecutor(), (long)pid);
        r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (RegionInfo)rsRI);
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, MetaTableAccessor.getRegionStateColumn((int)replicaId))));
        serverName = MetaTableAccessor.getServerName((Result)r, (int)0);
        TestCase.assertNotNull((Object)cluster.getRegionServer(serverName));
        Assert.assertNotEquals((Object)rsServerName, (Object)serverName);
        TestCase.assertFalse((boolean)this.searchMeta(master, rsServerName));
    }

    protected long scheduleHBCKSCP(ServerName rsServerName, HMaster master) throws ServiceException {
        return this.hbckscpScheduler.scheduleHBCKSCP(rsServerName, master);
    }

    @Override
    protected int getRegionReplication() {
        return this.replicas;
    }

    private boolean searchMeta(HMaster master, ServerName sn) throws IOException {
        List ps = MetaTableAccessor.getTableRegionsAndLocations((Connection)master.getConnection(), null);
        for (Pair p : ps) {
            if (!((ServerName)p.getSecond()).equals((Object)sn)) continue;
            return true;
        }
        return false;
    }

    private static class ReplicaNonMetaRegionSelector
    extends RegionSelector {
        private ReplicaNonMetaRegionSelector() {
        }

        @Override
        boolean regionFilter(RegionInfo info) {
            return !Objects.equals(TableName.META_TABLE_NAME, info.getTable()) && !Objects.equals(0, info.getReplicaId());
        }

        @Override
        Exception regionFilterFailure() {
            return new NoSuchElementException("Cannot locate a replica, non-meta region.");
        }
    }

    private static class PrimaryNotMetaRegionSelector
    extends RegionSelector {
        private PrimaryNotMetaRegionSelector() {
        }

        @Override
        boolean regionFilter(RegionInfo info) {
            return !Objects.equals(TableName.META_TABLE_NAME, info.getTable()) && Objects.equals(0, info.getReplicaId());
        }

        @Override
        Exception regionFilterFailure() {
            return new NoSuchElementException("Cannot locate a primary, non-meta region.");
        }
    }

    private static abstract class RegionSelector {
        private RegionSelector() {
        }

        abstract boolean regionFilter(RegionInfo var1);

        abstract Exception regionFilterFailure();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class ScheduleSCPsForUnknownServers
    extends HBCKSCPScheduler {
        private ScheduleSCPsForUnknownServers() {
        }

        @Override
        long scheduleHBCKSCP(ServerName rsServerName, HMaster master) throws ServiceException {
            MasterProtos.ScheduleSCPsForUnknownServersResponse response = master.getMasterRpcServices().scheduleSCPsForUnknownServers(null, MasterProtos.ScheduleSCPsForUnknownServersRequest.newBuilder().build());
            Assert.assertEquals((long)1L, (long)response.getPidCount());
            return response.getPid(0);
        }
    }

    private static class ScheduleServerCrashProcedure
    extends HBCKSCPScheduler {
        private ScheduleServerCrashProcedure() {
        }

        @Override
        public long scheduleHBCKSCP(ServerName rsServerName, HMaster master) throws ServiceException {
            MasterProtos.ScheduleServerCrashProcedureResponse response = master.getMasterRpcServices().scheduleServerCrashProcedure(null, MasterProtos.ScheduleServerCrashProcedureRequest.newBuilder().addServerName(ProtobufUtil.toServerName((ServerName)rsServerName)).build());
            Assert.assertEquals((long)1L, (long)response.getPidCount());
            return response.getPid(0);
        }
    }

    private static abstract class HBCKSCPScheduler {
        private HBCKSCPScheduler() {
        }

        abstract long scheduleHBCKSCP(ServerName var1, HMaster var2) throws ServiceException;

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

