/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.conf.ConfigKey;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestTableDescriptorChecker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableDescriptorChecker.class);

    @Test
    public void testSanityCheck() throws IOException {
        Configuration conf = new Configuration();
        TableDescriptorBuilder t = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"test"));
        ColumnFamilyDescriptorBuilder cf = ColumnFamilyDescriptorBuilder.newBuilder((byte[])"cf".getBytes());
        t.setColumnFamily(cf.build());
        TableDescriptorChecker.sanityCheck((Configuration)conf, (TableDescriptor)t.build());
        String key = "hbase.hstore.compaction.ratio";
        ConfigKey.INT((String)key, (Predicate[])new Predicate[]{v -> v > 0});
        t.setValue(key, "xx");
        Assert.assertThrows((String)"Should have thrown IllegalArgumentException", DoNotRetryIOException.class, () -> TableDescriptorChecker.sanityCheck((Configuration)conf, (TableDescriptor)t.build()));
        t.setValue(key, "1");
        TableDescriptorChecker.sanityCheck((Configuration)conf, (TableDescriptor)t.build());
        for (boolean viaSetValue : new boolean[]{true, false}) {
            if (viaSetValue) {
                cf.setValue(key, "xx");
            } else {
                cf.setConfiguration(key, "xx");
            }
            t.removeColumnFamily("cf".getBytes());
            t.setColumnFamily(cf.build());
            Assert.assertThrows((String)"Should have thrown IllegalArgumentException", DoNotRetryIOException.class, () -> TableDescriptorChecker.sanityCheck((Configuration)conf, (TableDescriptor)t.build()));
            if (viaSetValue) {
                cf.setValue(key, "");
            } else {
                cf.setConfiguration(key, "");
            }
            t.removeColumnFamily("cf".getBytes());
            t.setColumnFamily(cf.build());
            TableDescriptorChecker.sanityCheck((Configuration)conf, (TableDescriptor)t.build());
        }
    }
}

