/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestListTablesByState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestListTablesByState.class);
    private static HBaseTestingUtility UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 1;
    private static final byte[] COLUMN;
    private static final TableName TABLE;
    private static final TableDescriptor TABLE_DESC;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL = new HBaseTestingUtility();
        UTIL.startMiniCluster(1);
        ADMIN = UTIL.getAdmin();
    }

    @Before
    public void before() throws Exception {
        if (ADMIN.tableExists(TABLE)) {
            if (ADMIN.isTableEnabled(TABLE)) {
                ADMIN.disableTable(TABLE);
            }
            ADMIN.deleteTable(TABLE);
        }
    }

    @Test
    public void testListTableNamesByState() throws Exception {
        ADMIN.createTable(TABLE_DESC);
        ADMIN.disableTable(TABLE);
        Assert.assertEquals(ADMIN.listTableNamesByState(false).get(0), (Object)TABLE);
        ADMIN.enableTable(TABLE);
        Assert.assertEquals(ADMIN.listTableNamesByState(true).get(0), (Object)TABLE);
    }

    @Test
    public void testListTableDescriptorByState() throws Exception {
        ADMIN.createTable(TABLE_DESC);
        ADMIN.disableTable(TABLE);
        Assert.assertEquals((Object)((TableDescriptor)ADMIN.listTableDescriptorsByState(false).get(0)).getTableName(), (Object)TABLE);
        ADMIN.enableTable(TABLE);
        Assert.assertEquals((Object)((TableDescriptor)ADMIN.listTableDescriptorsByState(true).get(0)).getTableName(), (Object)TABLE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        if (UTIL != null) {
            UTIL.shutdownMiniCluster();
        }
    }

    static {
        COLUMN = Bytes.toBytes((String)"cf");
        TABLE = TableName.valueOf((String)"test");
        TABLE_DESC = TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN).setMaxVersions(3).build()).build();
    }
}

