/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BucketCachePersister
extends Thread {
    private final BucketCache cache;
    private final long intervalMillis;
    private static final Logger LOG = LoggerFactory.getLogger(BucketCachePersister.class);
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public BucketCachePersister(BucketCache cache, long intervalMillis) {
        super("bucket-cache-persister");
        this.cache = cache;
        this.intervalMillis = intervalMillis;
        LOG.info("BucketCachePersister started with interval: " + intervalMillis);
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    do {
                        Thread.sleep(this.intervalMillis);
                        if (!this.cache.isCacheInconsistent()) continue;
                        LOG.debug("Cache is inconsistent, persisting to disk");
                        this.cache.persistToFile();
                        this.cache.setCacheInconsistent(false);
                    } while (!this.shutdown.get());
                }
                catch (IOException e) {
                    LOG.warn("Exception in BucketCachePersister.", (Throwable)e);
                    continue;
                }
                break;
            }
            LOG.info("Finishing cache persister thread.");
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupting BucketCachePersister thread.", (Throwable)e);
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.interrupt();
    }
}

