/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Map;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface RegionMetrics {
    public byte[] getRegionName();

    public int getStoreCount();

    public int getStoreFileCount();

    public Size getStoreFileSize();

    public Size getMemStoreSize();

    public long getReadRequestCount();

    public long getWriteRequestCount();

    default public long getRequestCount() {
        return this.getReadRequestCount() + this.getWriteRequestCount();
    }

    default public String getNameAsString() {
        return Bytes.toStringBinary(this.getRegionName());
    }

    public long getFilteredReadRequestCount();

    public Size getStoreFileIndexSize();

    public Size getStoreFileRootLevelIndexSize();

    public Size getStoreFileUncompressedDataIndexSize();

    public Size getBloomFilterSize();

    public long getCompactingCellCount();

    public long getCompactedCellCount();

    public long getCompletedSequenceId();

    public Map<byte[], Long> getStoreSequenceId();

    public Size getUncompressedStoreFileSize();

    public float getDataLocality();

    public long getLastMajorCompactionTimestamp();

    public int getStoreRefCount();

    public int getMaxCompactedStoreFileRefCount();

    public float getDataLocalityForSsd();

    public long getBlocksLocalWeight();

    public long getBlocksLocalWithSsdWeight();

    public long getBlocksTotalWeight();

    public CompactionState getCompactionState();

    public Size getRegionSizeMB();

    public float getCurrentRegionCachedRatio();
}

