/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSingleByteBuff {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSingleByteBuff.class);

    @Test
    public void testPositionalReads() {
        this.testPositionalReads(ByteBuffer.allocateDirect(15));
        this.testPositionalReads(ByteBuffer.allocate(15));
    }

    private void testPositionalReads(ByteBuffer bb) {
        int i = 9;
        short s = 5;
        byte b = 2;
        long l = 1234L;
        bb.putInt(i);
        bb.putLong(l);
        bb.put(b);
        bb.putShort(s);
        SingleByteBuff sbb = new SingleByteBuff(bb);
        Assert.assertEquals((long)i, (long)sbb.getInt(0));
        Assert.assertEquals((long)l, (long)sbb.getLong(4));
        Assert.assertEquals((long)b, (long)sbb.get(12));
        Assert.assertEquals((long)s, (long)sbb.getShort(13));
        sbb.rewind();
        Assert.assertEquals((long)i, (long)sbb.getIntAfterPosition(0));
        Assert.assertEquals((long)l, (long)sbb.getLongAfterPosition(4));
        Assert.assertEquals((long)b, (long)sbb.getByteAfterPosition(12));
        Assert.assertEquals((long)s, (long)sbb.getShortAfterPosition(13));
    }
}

