/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertUtils;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import net.minidev.json.JSONArray;

public class X509CertChainUtils {
    public static List<Base64> toBase64List(JSONArray jsonArray) throws ParseException {
        if (jsonArray == null) {
            return null;
        }
        LinkedList<Base64> chain = new LinkedList<Base64>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object item = jsonArray.get(i);
            if (item == null) {
                throw new ParseException("The X.509 certificate at position " + i + " must not be null", 0);
            }
            if (!(item instanceof String)) {
                throw new ParseException("The X.509 certificate at position " + i + " must be encoded as a Base64 string", 0);
            }
            chain.add(new Base64((String)item));
        }
        return chain;
    }

    public static List<X509Certificate> parse(List<Base64> b64List) throws ParseException {
        if (b64List == null) {
            return null;
        }
        LinkedList<X509Certificate> out = new LinkedList<X509Certificate>();
        for (int i = 0; i < b64List.size(); ++i) {
            if (b64List.get(i) == null) continue;
            X509Certificate cert = X509CertUtils.parse(b64List.get(i).decode());
            if (cert == null) {
                throw new ParseException("Invalid X.509 certificate at position " + i, 0);
            }
            out.add(cert);
        }
        return out;
    }

    private X509CertChainUtils() {
    }
}

