/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.cursor;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();

    public EmptyCursor() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating EmptyCursor : {}", (Object)this);
        }
    }

    @Override
    public boolean available() {
        return false;
    }

    @Override
    public void before(E element) throws LdapException, CursorException {
        this.checkNotClosed("before()");
    }

    @Override
    public void after(E element) throws LdapException, CursorException {
        this.checkNotClosed("after()");
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed("first()");
        return false;
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed("last()");
        return false;
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        return false;
    }

    @Override
    public E get() throws CursorException {
        this.checkNotClosed("get()");
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_02004_EMPTY_CURSOR, new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing EmptyCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

