/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.MultiRowResultReader;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RestUtil;
import org.apache.hadoop.hbase.rest.RowSpec;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.javax.ws.rs.Encoded;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.HeaderParam;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.QueryParam;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MultivaluedMap;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Response;
import org.apache.hbase.thirdparty.javax.ws.rs.core.UriInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MultiRowResource
extends ResourceBase
implements Constants {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRowResource.class);
    private static final Base64.Decoder base64Urldecoder = Base64.getUrlDecoder();
    TableResource tableResource;
    Integer versions = null;
    String[] columns = null;

    public MultiRowResource(TableResource tableResource, String versions, String columnsStr) throws IOException {
        this.tableResource = tableResource;
        if (columnsStr != null && !columnsStr.equals("")) {
            this.columns = columnsStr.split(",");
        }
        if (versions != null) {
            this.versions = Integer.valueOf(versions);
        }
    }

    @GET
    @Produces(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo, @HeaderParam(value="Encoding") String keyEncodingHeader, @QueryParam(value="filter_b64") @Encoded String paramFilterB64, @QueryParam(value="filter") String paramFilter) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        String keyEncoding = keyEncodingHeader != null ? keyEncodingHeader : (String)params.getFirst((Object)"e");
        this.servlet.getMetrics().incrementRequests(1);
        byte[] filterBytes = null;
        if (paramFilterB64 != null) {
            filterBytes = base64Urldecoder.decode(paramFilterB64);
        } else if (paramFilter != null) {
            filterBytes = paramFilter.getBytes();
        }
        try {
            Filter parsedParamFilter = null;
            if (filterBytes != null) {
                ParseFilter pf = new ParseFilter();
                parsedParamFilter = pf.parseFilterString(filterBytes);
            }
            ArrayList<RowSpec> rowSpecs = new ArrayList<RowSpec>();
            if (params.containsKey((Object)"row")) {
                for (String rk : (List)params.get((Object)"row")) {
                    RowSpec rowSpec = new RowSpec(rk, keyEncoding);
                    if (this.versions != null) {
                        rowSpec.setMaxVersions(this.versions);
                    }
                    if (this.columns != null) {
                        for (int i = 0; i < this.columns.length; ++i) {
                            rowSpec.addColumn(Bytes.toBytes((String)this.columns[i]));
                        }
                    }
                    rowSpecs.add(rowSpec);
                }
            }
            MultiRowResultReader reader = new MultiRowResultReader(this.tableResource.getName(), rowSpecs, parsedParamFilter, !params.containsKey((Object)"nocache"));
            CellSetModel model = new CellSetModel();
            for (Result r : reader.getResults()) {
                if (r.isEmpty()) continue;
                model.addRow(RestUtil.createRowModelFromResult(r));
            }
            if (model.getRows().isEmpty()) {
                this.servlet.getMetrics().incrementFailedGetRequests(1);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"No rows found.\r\n").build();
            }
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)model).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return this.processException(e);
        }
    }
}

