/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import java.util.UUID;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidComparator
extends SerializableComparator<String> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(UuidComparator.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    public static UuidComparator INSTANCE = new UuidComparator("1.3.6.1.1.16.4");

    public UuidComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String uuid1, String uuid2) {
        if (IS_DEBUG) {
            LOG.debug("comparing UUID objects '{}' with '{}'", (Object)uuid1, (Object)uuid2);
        }
        if (uuid1 == null) {
            return uuid2 == null ? 0 : -1;
        }
        if (uuid2 == null) {
            return 1;
        }
        return uuid1.compareTo(uuid2);
    }

    @Override
    public int compare(UUID uuid1, UUID uuid2) {
        if (IS_DEBUG) {
            LOG.debug("comparing UUID objects '{}' with '{}'", (Object)uuid1, (Object)uuid2);
        }
        if (uuid1 == null) {
            return uuid2 == null ? 0 : -1;
        }
        if (uuid2 == null) {
            return 1;
        }
        return uuid1.compareTo(uuid2);
    }
}

