/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.ExpiredMobFileCleaner;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestExpiredMobFileCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExpiredMobFileCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName tableName = TableName.valueOf((String)"TestExpiredMobFileCleaner");
    private static final String family = "family";
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] row3 = Bytes.toBytes((String)"row3");
    private static final byte[] qf = Bytes.toBytes((String)"qf");
    private static final Logger LOG = LoggerFactory.getLogger(TestExpiredMobFileCleaner.class);
    private static BufferedMutator table;
    private static Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.mob.cleaner.batch.size.upper.bound", 2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.getTestFileSystem().delete(TEST_UTIL.getDataTestDir(), true);
    }

    private void init() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)desc);
        table = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration()).getBufferedMutator(tableName);
    }

    private void modifyColumnExpiryDays(int expireDays) throws Exception {
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        int timeToLive = expireDays * this.secondsOfDay();
        hcd.setTimeToLive(timeToLive);
        admin.modifyColumnFamily(tableName, (ColumnFamilyDescriptor)hcd);
    }

    private void putKVAndFlush(BufferedMutator table, byte[] row, byte[] value, long ts) throws Exception {
        Put put = new Put(row, ts);
        put.addColumn(Bytes.toBytes((String)family), qf, value);
        table.mutate((Mutation)put);
        table.flush();
        admin.flush(tableName);
    }

    @Test
    public void testCleaner() throws Exception {
        this.init();
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tableName, (String)family);
        byte[] dummyData = this.makeDummyData(600);
        long ts = EnvironmentEdgeManager.currentTime() - (long)(3 * this.secondsOfDay() * 1000);
        this.putKVAndFlush(table, row1, dummyData, ts);
        LOG.info("test log to be deleted, tablename is " + tableName);
        CommonFSUtils.logFileSystemState((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)TEST_UTIL.getDefaultRootDirPath(), (Logger)LOG);
        FileStatus[] firstFiles = TEST_UTIL.getTestFileSystem().listStatus(mobDirPath);
        Assert.assertEquals((String)"Before cleanup without delay 1", (long)1L, (long)firstFiles.length);
        String firstFile = firstFiles[0].getPath().getName();
        ts = (long)((double)EnvironmentEdgeManager.currentTime() - 1.5 * (double)this.secondsOfDay() * 1000.0);
        this.putKVAndFlush(table, row2, dummyData, ts);
        FileStatus[] secondFiles = TEST_UTIL.getTestFileSystem().listStatus(mobDirPath);
        Assert.assertEquals((String)"Before cleanup without delay 2", (long)2L, (long)secondFiles.length);
        String f1 = secondFiles[0].getPath().getName();
        String f2 = secondFiles[1].getPath().getName();
        String secondFile = f1.equals(firstFile) ? f2 : f1;
        ts = EnvironmentEdgeManager.currentTime() - (long)(4 * this.secondsOfDay() * 1000);
        this.putKVAndFlush(table, row3, dummyData, ts);
        ts = EnvironmentEdgeManager.currentTime() - (long)(4 * this.secondsOfDay() * 1000);
        this.putKVAndFlush(table, row3, dummyData, ts);
        FileStatus[] thirdFiles = TEST_UTIL.getTestFileSystem().listStatus(mobDirPath);
        Assert.assertEquals((String)"Before cleanup without delay 3", (long)4L, (long)thirdFiles.length);
        this.modifyColumnExpiryDays(2);
        String[] args = new String[]{tableName.getNameAsString(), family};
        ToolRunner.run((Configuration)TEST_UTIL.getConfiguration(), (Tool)new ExpiredMobFileCleaner(), (String[])args);
        FileStatus[] filesAfterClean = TEST_UTIL.getTestFileSystem().listStatus(mobDirPath);
        String lastFile = filesAfterClean[0].getPath().getName();
        Assert.assertEquals((String)"After cleanup without delay 1", (long)1L, (long)filesAfterClean.length);
        Assert.assertEquals((String)"After cleanup without delay 2", (Object)secondFile, (Object)lastFile);
    }

    private int secondsOfDay() {
        return 86400;
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        Bytes.random((byte[])dummyData);
        return dummyData;
    }
}

