/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientTableMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientTableMetrics.class);
    private static HBaseTestingUtility UTIL;
    private static Connection CONN;
    private static MetricsConnection METRICS;
    private static final String tableName = "table_1";
    private static final TableName TABLE_1;
    private static final byte[] FAMILY;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.client.metrics.enable", true);
        conf.setBoolean("hbase.client.table.metrics.enable", true);
        UTIL = new HBaseTestingUtility(conf);
        UTIL.startMiniCluster(2);
        UTIL.createTable(TABLE_1, FAMILY);
        UTIL.waitTableAvailable(TABLE_1);
        CONN = UTIL.getConnection();
        METRICS = ((ConnectionImplementation)CONN).getConnectionMetrics();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.deleteTableIfAny(TABLE_1);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetTableMetrics() throws IOException {
        Table table = CONN.getTable(TABLE_1);
        table.get(new Get(Bytes.toBytes((String)"row1")));
        table.get(new Get(Bytes.toBytes((String)"row2")));
        table.get(new Get(Bytes.toBytes((String)"row3")));
        table.close();
        String metricKey = "rpcCallDurationMs_" + ClientProtos.ClientService.getDescriptor().getName() + "_Get_" + tableName;
        TestClientTableMetrics.verifyTableMetrics(metricKey, 3);
    }

    @Test
    public void testMutateTableMetrics() throws IOException {
        Table table = CONN.getTable(TABLE_1);
        Put put = new Put(Bytes.toBytes((String)"row1"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"name"), Bytes.toBytes((String)"tom"));
        table.put(put);
        put = new Put(Bytes.toBytes((String)"row2"));
        put.addColumn(FAMILY, Bytes.toBytes((String)"name"), Bytes.toBytes((String)"jerry"));
        table.put(put);
        table.delete(new Delete(Bytes.toBytes((String)"row1")));
        table.close();
        String metricKey = "rpcCallDurationMs_" + ClientProtos.ClientService.getDescriptor().getName() + "_Mutate(Put)_" + tableName;
        TestClientTableMetrics.verifyTableMetrics(metricKey, 2);
        metricKey = "rpcCallDurationMs_" + ClientProtos.ClientService.getDescriptor().getName() + "_Mutate(Delete)_" + tableName;
        TestClientTableMetrics.verifyTableMetrics(metricKey, 1);
    }

    @Test
    public void testScanTableMetrics() throws IOException {
        Table table = CONN.getTable(TABLE_1);
        table.getScanner(new Scan());
        table.close();
        String metricKey = "rpcCallDurationMs_" + ClientProtos.ClientService.getDescriptor().getName() + "_Scan_" + tableName;
        TestClientTableMetrics.verifyTableMetrics(metricKey, 1);
    }

    @Test
    public void testMultiTableMetrics() throws IOException {
        Table table = CONN.getTable(TABLE_1);
        table.put(Arrays.asList(new Put(Bytes.toBytes((String)"row1")).addColumn(FAMILY, Bytes.toBytes((String)"name"), Bytes.toBytes((String)"tom")), new Put(Bytes.toBytes((String)"row2")).addColumn(FAMILY, Bytes.toBytes((String)"name"), Bytes.toBytes((String)"jerry"))));
        table.get(Arrays.asList(new Get(Bytes.toBytes((String)"row1")), new Get(Bytes.toBytes((String)"row2"))));
        table.close();
        String metricKey = "rpcCallDurationMs_" + ClientProtos.ClientService.getDescriptor().getName() + "_Multi_" + tableName;
        TestClientTableMetrics.verifyTableMetrics(metricKey, 2);
    }

    private static void verifyTableMetrics(String metricKey, int expectedVal) {
        String numOpsSuffix = "_num_ops";
        String p95Suffix = "_95th_percentile";
        String p99Suffix = "_99th_percentile";
        Timer timer = (Timer)METRICS.getRpcTimers().get(metricKey);
        long numOps = timer.getCount();
        double p95 = timer.getSnapshot().get95thPercentile();
        double p99 = timer.getSnapshot().get99thPercentile();
        Assert.assertEquals((String)("metric: " + metricKey + numOpsSuffix + " val: " + numOps), (long)expectedVal, (long)numOps);
        Assert.assertTrue((String)("metric: " + metricKey + p95Suffix + " val: " + p95), (p95 >= 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("metric: " + metricKey + p99Suffix + " val: " + p99), (p99 >= 0.0 ? 1 : 0) != 0);
    }

    static {
        TABLE_1 = TableName.valueOf((String)tableName);
        FAMILY = Bytes.toBytes((String)"f");
    }
}

