/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFsLimits {
    static Configuration conf;
    static FSNamesystem fs;
    static boolean fsIsReady;
    static final PermissionStatus perms;

    private static FSNamesystem getMockNamesystem() throws IOException {
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog editLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        ((FSImage)Mockito.doReturn((Object)editLog).when((Object)fsImage)).getEditLog();
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.setImageLoaded(fsIsReady);
        return fsn;
    }

    @Before
    public void setUp() throws IOException {
        conf = new Configuration();
        conf.set("dfs.namenode.name.dir", Util.fileAsURI((File)new File(MiniDFSCluster.getBaseDirectory(), "namenode")).toString());
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fs = null;
        fsIsReady = true;
    }

    @Test
    public void testNoLimits() throws Exception {
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
        this.mkdirs("/55555", null);
        this.mkdirs("/1/.snapshot", HadoopIllegalArgumentException.class);
    }

    @Test
    public void testMaxComponentLength() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.PathComponentTooLongException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testMaxComponentLengthRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 2);
        this.mkdirs("/5", null);
        this.rename("/5", "/555", FSLimitException.PathComponentTooLongException.class);
        this.rename("/5", "/55", null);
        this.mkdirs("/6", null);
        this.deprecatedRename("/6", "/666", FSLimitException.PathComponentTooLongException.class);
        this.deprecatedRename("/6", "/66", null);
    }

    @Test
    public void testMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.MaxDirectoryItemsExceededException.class);
    }

    @Test
    public void testMaxDirItemsRename() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/2", null);
        this.mkdirs("/2/A", null);
        this.rename("/2/A", "/A", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.rename("/2/A", "/1/A", null);
        this.mkdirs("/2/B", null);
        this.deprecatedRename("/2/B", "/B", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.deprecatedRename("/2/B", "/1/B", null);
        this.rename("/1", "/3", null);
        this.deprecatedRename("/2", "/4", null);
    }

    @Test
    public void testMaxDirItemsLimits() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0);
        try {
            this.mkdirs("1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set dfs", (Throwable)e);
        }
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 0x640000);
        try {
            this.mkdirs("1", null);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot set dfs", (Throwable)e);
        }
    }

    @Test
    public void testMaxComponentsAndMaxDirItems() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", FSLimitException.MaxDirectoryItemsExceededException.class);
        this.mkdirs("/4444", FSLimitException.PathComponentTooLongException.class);
    }

    @Test
    public void testDuringEditLogs() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 3);
        conf.setInt("dfs.namenode.fs-limits.max-directory-items", 2);
        fsIsReady = false;
        this.mkdirs("/1", null);
        this.mkdirs("/22", null);
        this.mkdirs("/333", null);
        this.mkdirs("/4444", null);
        this.mkdirs("/1/.snapshot", HadoopIllegalArgumentException.class);
    }

    @Test
    public void testParentDirectoryNameIsCorrect() throws Exception {
        conf.setInt("dfs.namenode.fs-limits.max-component-length", 20);
        this.mkdirs("/user", null);
        this.mkdirs("/user/testHome", null);
        this.mkdirs("/user/testHome/FileNameLength", null);
        this.mkdirCheckParentDirectory("/user/testHome/FileNameLength/really_big_name_0003_fail", "/user/testHome/FileNameLength", FSLimitException.PathComponentTooLongException.class);
        this.renameCheckParentDirectory("/user/testHome/FileNameLength", "/user/testHome/really_big_name_0003_fail", "/user/testHome", FSLimitException.PathComponentTooLongException.class);
    }

    private void mkdirCheckParentDirectory(String name, String ParentDirName, Class<?> expected) throws Exception {
        this.verify(this.mkdirs(name, expected), ParentDirName);
    }

    private void renameCheckParentDirectory(String name, String dst, String ParentDirName, Class<?> expected) throws Exception {
        this.verify(this.rename(name, dst, expected), ParentDirName);
    }

    private void verify(String message, String ParentDirName) {
        boolean found = false;
        if (message != null) {
            String[] tokens;
            for (String token : tokens = message.split("\\s+")) {
                if (token == null || !token.equals(ParentDirName)) continue;
                found = true;
                break;
            }
        }
        Assert.assertTrue((boolean)found);
    }

    private String mkdirs(String name, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        String errorString = null;
        try {
            fs.mkdirs(name, perms, false);
        }
        catch (Throwable e) {
            generated = e.getClass();
            e.printStackTrace();
            errorString = e.getMessage();
        }
        Assert.assertEquals(expected, generated);
        return errorString;
    }

    private String rename(String src, String dst, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        String errorString = null;
        try {
            fs.renameTo(src, dst, false, new Options.Rename[0]);
        }
        catch (Throwable e) {
            generated = e.getClass();
            errorString = e.getMessage();
        }
        Assert.assertEquals(expected, generated);
        return errorString;
    }

    private void deprecatedRename(String src, String dst, Class<?> expected) throws Exception {
        TestFsLimits.lazyInitFSDirectory();
        Class<?> generated = null;
        try {
            fs.renameTo(src, dst, false);
        }
        catch (Throwable e) {
            generated = e.getClass();
        }
        Assert.assertEquals(expected, generated);
    }

    private static void lazyInitFSDirectory() throws IOException {
        if (fs == null) {
            fs = TestFsLimits.getMockNamesystem();
        }
    }

    static {
        perms = new PermissionStatus("admin", "admin", FsPermission.getDefault());
    }
}

