/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoDisplay;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RegionListTmplImpl
extends AbstractTemplateImpl
implements RegionListTmpl.Intf {
    private final HRegionServer regionServer;
    private final List<RegionInfo> onlineRegions;

    protected static RegionListTmpl.ImplData __jamon_setOptionalArguments(RegionListTmpl.ImplData p_implData) {
        return p_implData;
    }

    public RegionListTmplImpl(TemplateManager p_templateManager, RegionListTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RegionListTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.onlineRegions = p_implData.getOnlineRegions();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.onlineRegions != null && this.onlineRegions.size() > 0) {
            jamonWriter.write("\n\n    ");
            Collections.sort(this.onlineRegions, RegionInfo.COMPARATOR);
            jamonWriter.write("<div class=\"tabbable\">\n        <ul class=\"nav nav-pills\" role=\"tablist\">\n            <li class=\"nav-item\"><a class=\"nav-link active\" href=\"#tab_regionBaseInfo\" data-bs-toggle=\"tab\" role=\"tab\">Base Info</a> </li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_regionRequestStats\" data-bs-toggle=\"tab\" role=\"tab\">Request metrics</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_regionStoreStats\" data-bs-toggle=\"tab\" role=\"tab\">Storefile Metrics</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_regionMemstoreStats\" data-bs-toggle=\"tab\" role=\"tab\">Memstore Metrics</a></li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_regionCompactStats\" data-bs-toggle=\"tab\" role=\"tab\">Compaction Metrics</a></li>\n        </ul>\n        <div class=\"tab-content\">\n            <div class=\"tab-pane active\" id=\"tab_regionBaseInfo\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__baseInfo(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionRequestStats\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__requestStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionStoreStats\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__storeStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionMemstoreStats\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__memstoreStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_regionCompactStats\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__compactStats(jamonWriter, this.onlineRegions);
            jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p>Region names are made of the containing table's name, a comma,\n    the start key, a comma, and a randomly generated region id.  To illustrate,\n    the region named\n    <em>domains,apache.org,5464829424211263407</em> is party to the table\n    <em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\n    in the region is <em>apache.org</em>.  The <em>hbase:meta</em> 'table' is an internal\n    system table (or a 'catalog' table in db-speak).\n    The hbase:meta table keeps a list of all regions in the system. The empty key is used to denote\n    table start and table end.  A region with an empty start key is the first region in a table.\n    If a region has both an empty start key and an empty end key, it's the only region in the\n    table. See <a href=\"http://hbase.apache.org\">HBase Home</a> for further explication.<p>\n");
        } else {
            jamonWriter.write("\n    <p>Not serving regions</p>\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__baseInfo(Writer jamonWriter, List<RegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table id=\"baseStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th class=\"cls_emptyMin\">Start Key</th>\n            <th class=\"cls_emptyMax\">End Key</th>\n            <th>ReplicaID</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
        for (RegionInfo r : onlineRegions) {
            jamonWriter.write("\n        <tr>\n            ");
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)displayName), jamonWriter);
            jamonWriter.write("</a></td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary((byte[])RegionInfoDisplay.getStartKeyForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration()))), jamonWriter);
            jamonWriter.write("</td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)Bytes.toStringBinary((byte[])RegionInfoDisplay.getEndKeyForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration()))), jamonWriter);
            jamonWriter.write("</td>\n            <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)r.getReplicaId()), jamonWriter);
            jamonWriter.write("</td>\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </tbody>\n    </table>\n");
    }

    private void __jamon_innerUnit__compactStats(Writer jamonWriter, List<RegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table id=\"compactionStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th class=\"cls_separator\">Num. Compacting Cells</th>\n            <th class=\"cls_separator\">Num. Compacted Cells</th>\n            <th>Compaction Progress</th>\n            <th data-date-format=\"yyyymmdd hhmm zz\">Last Major Compaction</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
        for (RegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            String percentDone = "";
            String compactTime = "";
            if (load != null) {
                if (load.getTotalCompactingKVs() > 0L) {
                    percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)load.getCurrentCompactedKVs() / (float)load.getTotalCompactingKVs()))) + "%";
                }
                if (load.getLastMajorCompactionTs() > 0L) {
                    FastDateFormat fdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm (ZZ)");
                    compactTime = fdf.format(load.getLastMajorCompactionTs());
                }
            }
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)displayName), jamonWriter);
            jamonWriter.write("</a></td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getTotalCompactingKVs())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getCurrentCompactedKVs())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)percentDone), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)compactTime), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </tbody>\n    </table>\n");
    }

    private void __jamon_innerUnit__memstoreStats(Writer jamonWriter, List<RegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table id=\"memstoreStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th class=\"cls_filesize\">Memstore Size</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
        for (RegionInfo r : onlineRegions) {
            long memStoreSizeMB;
            jamonWriter.write("\n\n        <tr>\n        ");
            String ZEROMB = "0 MB";
            String memStoreSizeMBStr = "0 MB";
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration());
            if (load != null && (memStoreSizeMB = (long)load.getMemStoreSizeMB()) > 0L) {
                memStoreSizeMBStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(memStoreSizeMB * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)displayName), jamonWriter);
            jamonWriter.write("</a></td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)memStoreSizeMBStr), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </tbody>\n    </table>\n");
    }

    private void __jamon_innerUnit__requestStats(Writer jamonWriter, List<RegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table id=\"requestStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th class=\"cls_separator\">Read Request Count</th>\n            <th class=\"cls_separator\">Filtered Read Request Count</th>\n            <th class=\"cls_separator\">Write Request Count</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
        for (RegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration());
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)displayName), jamonWriter);
            jamonWriter.write("</a></td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getReadRequestsCount())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getFilteredReadRequestsCount())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getWriteRequestsCount())), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </tbody>\n    </table>\n");
    }

    private void __jamon_innerUnit__storeStats(Writer jamonWriter, List<RegionInfo> onlineRegions) throws IOException {
        jamonWriter.write("<table id=\"storeStatsTable\" class=\"tablesorter table table-striped\">\n    <thead>\n        <tr>\n            <th>Region Name</th>\n            <th class=\"cls_separator\">Num. Stores</th>\n            <th class=\"cls_separator\">Num. Storefiles</th>\n            <th class=\"cls_filesize\">Storefile Size Uncompressed</th>\n            <th class=\"cls_filesize\">Storefile Size</th>\n            <th class=\"cls_filesize\">Index Size</th>\n            <th class=\"cls_filesize\">Bloom Size</th>\n            <th>Data Locality</th>\n            <th>Len Of Biggest Cell</th>\n            <th>% Cached</th>\n        </tr>\n    </thead>\n\n    <tbody>\n        ");
        for (RegionInfo r : onlineRegions) {
            jamonWriter.write("\n\n        <tr>\n        ");
            String ZEROMB = "0 MB";
            String ZEROKB = "0 KB";
            String uncompressedStorefileSizeStr = "0 MB";
            String storefileSizeStr = "0 MB";
            String indexSizeStr = "0 KB";
            String bloomSizeStr = "0 KB";
            ClusterStatusProtos.RegionLoad load = this.regionServer.createRegionLoad(r.getEncodedName());
            String displayName = RegionInfoDisplay.getRegionNameAsStringForDisplay((RegionInfo)r, (Configuration)this.regionServer.getConfiguration());
            if (load != null) {
                long uncompressedStorefileSize = load.getStoreUncompressedSizeMB();
                long storefileSize = load.getStorefileSizeMB();
                long indexSize = load.getTotalStaticIndexSizeKB();
                long bloomSize = load.getTotalStaticBloomSizeKB();
                if (uncompressedStorefileSize > 0L) {
                    uncompressedStorefileSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(uncompressedStorefileSize * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if (storefileSize > 0L) {
                    storefileSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(storefileSize * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
                }
                if (indexSize > 0L) {
                    indexSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(indexSize * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
                }
                if (bloomSize > 0L) {
                    bloomSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(bloomSize * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
                }
            }
            long lenOfBiggestCellInRegion = -1L;
            HRegion region = this.regionServer.getRegion(r.getEncodedName());
            if (region != null) {
                List<? extends Store> stores = region.getStores();
                for (Store store : stores) {
                    Collection<? extends StoreFile> storeFiles = store.getStorefiles();
                    for (StoreFile storeFile : storeFiles) {
                        long lenOfBiggestCell = ((HStoreFile)storeFile).getFileInfo().getHFileInfo().getLenOfBiggestCell();
                        if (lenOfBiggestCellInRegion >= lenOfBiggestCell) continue;
                        lenOfBiggestCellInRegion = lenOfBiggestCell;
                    }
                }
            }
            jamonWriter.write("<td><a href=\"region.jsp?name=");
            Escaping.HTML.write(StandardEmitter.valueOf((String)r.getEncodedName()), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)displayName), jamonWriter);
            jamonWriter.write("</a></td>\n            ");
            if (load != null) {
                jamonWriter.write("\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getStores())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", load.getStorefiles())), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)uncompressedStorefileSizeStr), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)storefileSizeStr), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)indexSizeStr), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)bloomSizeStr), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((float)load.getDataLocality()), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,1d", lenOfBiggestCellInRegion)), jamonWriter);
                jamonWriter.write("</td>\n            <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.formatPercent((double)load.getCurrentRegionCachedRatio(), (int)2)), jamonWriter);
                jamonWriter.write("</td>\n            ");
            }
            jamonWriter.write("\n        </tr>\n        ");
        }
        jamonWriter.write("\n    </tbody>\n    </table>\n");
    }
}

