/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.entity.AsyncEntityProducers;
import org.apache.hc.core5.http.nio.entity.NoopEntityConsumer;
import org.apache.hc.core5.http.nio.ssl.BasicServerTlsStrategy;
import org.apache.hc.core5.http.nio.ssl.FixedPortStrategy;
import org.apache.hc.core5.http.nio.ssl.SecurePortStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncResponseBuilder;
import org.apache.hc.core5.http.nio.support.BasicRequestConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpDateGenerator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;

public final class NHttpFileServer {
    public static final boolean DEBUG = Boolean.getBoolean(NHttpFileServer.class.getSimpleName() + ".debug");
    private final File docRoot;
    private ListenerEndpoint listenerEndpoint;
    private final int port;
    private HttpAsyncServer server;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Please specify document root directory");
            System.exit(1);
        }
        File docRoot = new File(args[0]);
        int port = 8080;
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        NHttpFileServer.start(port, docRoot, 0L).awaitTermination();
    }

    static void println(String msg) {
        if (DEBUG) {
            System.out.println(HttpDateGenerator.INSTANCE.getCurrentDate() + " | " + msg);
        }
    }

    public static NHttpFileServer start(int port, File docRoot, long waitMillis) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, InterruptedException, ExecutionException {
        return new NHttpFileServer(port, docRoot).start();
    }

    private NHttpFileServer(int port, File docRoot) {
        this.port = port;
        this.docRoot = docRoot;
    }

    private void awaitTermination() throws InterruptedException {
        this.server.awaitShutdown(TimeValue.MAX_VALUE);
    }

    public void close() {
        if (this.server.getStatus() == IOReactorStatus.ACTIVE) {
            CloseMode closeMode = CloseMode.GRACEFUL;
            NHttpFileServer.println("HTTP server shutting down (closeMode=" + closeMode + ")...");
            this.server.close(closeMode);
            NHttpFileServer.println("HTTP server shut down.");
        }
    }

    public int getPort() {
        if (this.server == null) {
            return this.port;
        }
        return ((InetSocketAddress)this.listenerEndpoint.getAddress()).getPort();
    }

    public void shutdown(long gracePeriod, TimeUnit timeUnit) throws InterruptedException {
        if (this.server != null) {
            this.server.initiateShutdown();
            this.server.awaitShutdown(TimeValue.of((long)gracePeriod, (TimeUnit)timeUnit));
        }
    }

    private NHttpFileServer start() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, InterruptedException, ExecutionException {
        AsyncServerBootstrap bootstrap = AsyncServerBootstrap.bootstrap();
        SSLContext sslContext = null;
        if (this.port == 8443 || this.port == 443) {
            URL url = NHttpFileServer.class.getResource("/test.keystore");
            if (url == null) {
                NHttpFileServer.println("Keystore not found");
                System.exit(1);
            }
            NHttpFileServer.println("Loading keystore " + url);
            sslContext = SSLContexts.custom().loadKeyMaterial(url, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
            bootstrap.setTlsStrategy((TlsStrategy)new BasicServerTlsStrategy(sslContext, (SecurePortStrategy)new FixedPortStrategy(new int[]{this.port})));
        }
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        this.server = bootstrap.setExceptionCallback(Throwable::printStackTrace).setIOReactorConfig(config).register("*", (AsyncServerRequestHandler)new HttpFileHandler(this.docRoot)).create();
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        this.server.start();
        Future future = this.server.listen((SocketAddress)new InetSocketAddress(this.port));
        this.listenerEndpoint = (ListenerEndpoint)future.get();
        NHttpFileServer.println("Serving " + this.docRoot + " on " + this.listenerEndpoint.getAddress() + (sslContext == null ? "" : " with " + sslContext.getProvider() + " " + sslContext.getProtocol()));
        return this;
    }

    private static class HttpFileHandler
    implements AsyncServerRequestHandler<Message<HttpRequest, Void>> {
        private final File docRoot;

        HttpFileHandler(File docRoot) {
            this.docRoot = docRoot;
        }

        public void handle(Message<HttpRequest, Void> message, AsyncServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
            URI requestUri;
            NHttpFileServer.println("Handling " + message + " in " + context);
            HttpRequest request = (HttpRequest)message.getHead();
            String method = request.getMethod().toUpperCase(Locale.ROOT);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            try {
                requestUri = request.getUri();
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), (Throwable)ex);
            }
            String path = requestUri.getPath();
            File file = new File(this.docRoot, path);
            ContentType mimeType = ContentType.TEXT_HTML;
            if (!file.exists()) {
                String msg = "File " + file.getPath() + " not found";
                NHttpFileServer.println(msg);
                responseTrigger.submitResponse(AsyncResponseBuilder.create((int)404).setEntity("<html><body><h1>" + msg + "</h1></body></html>", mimeType).build(), context);
            } else if (!file.canRead()) {
                String msg = "Cannot read file " + file.getPath();
                NHttpFileServer.println(msg);
                responseTrigger.submitResponse(AsyncResponseBuilder.create((int)403).setEntity("<html><body><h1>" + msg + "</h1></body></html>", mimeType).build(), context);
            } else {
                String fileName = file.getName().toLowerCase(Locale.ROOT);
                ContentType contentType = ContentType.TEXT_HTML;
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                EndpointDetails endpoint = coreContext.getEndpointDetails();
                NHttpFileServer.println(endpoint + " | serving file " + file.getPath());
                responseTrigger.submitResponse(AsyncResponseBuilder.create((int)200).setEntity(file.isDirectory() ? AsyncEntityProducers.create((String)file.toString(), (ContentType)contentType) : AsyncEntityProducers.create((File)file, (ContentType)contentType)).addHeader("Last-Modified", DateUtils.formatDate((Date)new Date(file.lastModified()))).build(), context);
            }
        }

        public AsyncRequestConsumer<Message<HttpRequest, Void>> prepare(HttpRequest request, EntityDetails entityDetails, HttpContext context) throws HttpException {
            return new BasicRequestConsumer((AsyncEntityConsumer)(entityDetails != null ? new NoopEntityConsumer() : null));
        }
    }
}

