/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.numbers.core.Precision;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.InferenceException;

final class BrentOptimizer {
    private static final double GOLDEN_SECTION = 0.3819660112501051;
    private static final double MIN_RELATIVE_TOLERANCE = 4.440892098500626E-16;
    private final double relativeThreshold;
    private final double absoluteThreshold;
    private int evaluations;

    BrentOptimizer(double rel, double abs) {
        if (!(rel >= 4.440892098500626E-16)) {
            throw new InferenceException("%s < %s", rel, 4.440892098500626E-16);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = Arguments.checkStrictlyPositive(abs);
    }

    int getEvaluations() {
        return this.evaluations;
    }

    PointValuePair optimize(DoubleUnaryOperator func, double lo, double hi, double mid, double fMid) {
        double fx;
        double x;
        double b;
        double a;
        if (lo < hi) {
            a = lo;
            b = hi;
        } else {
            a = hi;
            b = lo;
        }
        if (!(a < mid) || !(mid < b)) {
            throw new InferenceException("Invalid bounds: (%s, %s) with start %s", a, b, mid);
        }
        double v = x = mid;
        double w = x;
        double d = 0.0;
        double e = 0.0;
        double fv = fx = fMid;
        double fw = fx;
        double bestX = x;
        double bestFx = fx;
        this.evaluations = 0;
        while (true) {
            double m = 0.5 * (a + b);
            double tol1 = this.relativeThreshold * Math.abs(x) + this.absoluteThreshold;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - m) <= tol2 - 0.5 * (b - a)) {
                return PointValuePair.of(bestX, bestFx);
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                } else {
                    q = -q;
                }
                r = e;
                e = d;
                if (p > q * (a - x) && p < q * (b - x) && Math.abs(p) < Math.abs(0.5 * q * r)) {
                    d = p / q;
                    double u = x + d;
                    if (u - a < tol2 || b - u < tol2) {
                        d = x <= m ? tol1 : -tol1;
                    }
                } else {
                    e = x < m ? b - x : a - x;
                    d = 0.3819660112501051 * e;
                }
            } else {
                e = x < m ? b - x : a - x;
                d = 0.3819660112501051 * e;
            }
            double u = Math.abs(d) < tol1 ? (d >= 0.0 ? x + tol1 : x - tol1) : x + d;
            ++this.evaluations;
            double fu = func.applyAsDouble(u);
            if (fu < bestFx) {
                bestX = u;
                bestFx = fu;
            }
            if (fu <= fx) {
                if (u < x) {
                    b = x;
                } else {
                    a = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
                continue;
            }
            if (u < x) {
                a = u;
            } else {
                b = u;
            }
            if (fu <= fw || Precision.equals((double)w, (double)x)) {
                v = w;
                fv = fw;
                w = u;
                fw = fu;
                continue;
            }
            if (!(fu <= fv) && !Precision.equals((double)v, (double)x) && !Precision.equals((double)v, (double)w)) continue;
            v = u;
            fv = fu;
        }
    }

    static final class PointValuePair {
        private final double point;
        private final double value;

        private PointValuePair(double point, double value) {
            this.point = point;
            this.value = value;
        }

        static PointValuePair of(double point, double value) {
            return new PointValuePair(point, value);
        }

        double getPoint() {
            return this.point;
        }

        double getValue() {
            return this.value;
        }
    }
}

