/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.BaseProvider;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class IntProvider
extends BaseProvider
implements RandomIntSource {
    private static final int EMPTY_BOOL_SOURCE = 1;
    private int booleanSource = 1;

    public IntProvider() {
    }

    protected IntProvider(IntProvider source) {
        this.booleanSource = source.booleanSource;
    }

    protected void resetCachedState() {
        this.booleanSource = 1;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(this.booleanSource), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 4);
        this.booleanSource = NumberFactory.makeInt(c[0]);
        super.setStateInternal(c[1]);
    }

    public int nextInt() {
        return this.next();
    }

    public boolean nextBoolean() {
        int bits = this.booleanSource;
        if (bits == 1) {
            bits = this.next();
            this.booleanSource = Integer.MIN_VALUE | bits >>> 1;
            return (bits & 1) == 1;
        }
        this.booleanSource = bits >>> 1;
        return (bits & 1) == 1;
    }

    public double nextDouble() {
        return NumberFactory.makeDouble(this.next(), this.next());
    }

    public long nextLong() {
        return NumberFactory.makeLong(this.next(), this.next());
    }

    public void nextBytes(byte[] bytes) {
        IntProvider.nextBytesFill(this, bytes, 0, bytes.length);
    }

    public void nextBytes(byte[] bytes, int start, int len) {
        IntProvider.checkFromIndexSize(start, len, bytes.length);
        IntProvider.nextBytesFill(this, bytes, start, len);
    }

    static void nextBytesFill(RandomIntSource source, byte[] bytes, int start, int len) {
        int index = start;
        int indexLoopLimit = index + (len & 0x7FFFFFFC);
        while (index < indexLoopLimit) {
            int random = source.next();
            bytes[index++] = (byte)random;
            bytes[index++] = (byte)(random >>> 8);
            bytes[index++] = (byte)(random >>> 16);
            bytes[index++] = (byte)(random >>> 24);
        }
        int indexLimit = start + len;
        if (index < indexLimit) {
            int random = source.next();
            while (true) {
                bytes[index++] = (byte)random;
                if (index >= indexLimit) break;
                random >>>= 8;
            }
        }
    }

    private static int checkFromIndexSize(int fromIndex, int size, int length) {
        if ((fromIndex | size | length) < 0 || size > length - fromIndex) {
            throw new IndexOutOfBoundsException(String.format("Range [%d, %<d + %d) out of bounds for length %d", fromIndex, size, length));
        }
        return fromIndex;
    }
}

