/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public abstract class TSampler
implements SharedStateContinuousSampler {
    private static final double HUGE_DF = 9.007199254740992E15;
    private final UniformRandomProvider rng;

    TSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public abstract TSampler withUniformRandomProvider(UniformRandomProvider var1);

    long nextLong() {
        return this.rng.nextLong();
    }

    public String toString() {
        return "Student's t deviate [" + this.rng.toString() + "]";
    }

    public static TSampler of(UniformRandomProvider rng, double degreesOfFreedom) {
        if (degreesOfFreedom > 9.007199254740992E15) {
            return new NormalTSampler(rng);
        }
        if (degreesOfFreedom > 0.0) {
            return new StudentsTSampler(rng, degreesOfFreedom);
        }
        throw new IllegalArgumentException("degrees of freedom is not strictly positive: " + degreesOfFreedom);
    }

    private static final class NormalTSampler
    extends TSampler {
        private final NormalizedGaussianSampler sampler;

        NormalTSampler(UniformRandomProvider rng) {
            super(rng);
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
        }

        @Override
        public double sample() {
            return this.sampler.sample();
        }

        @Override
        public NormalTSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new NormalTSampler(rng);
        }
    }

    private static final class StudentsTSampler
    extends TSampler {
        private static final double LARGE_DF = 25.0;
        private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;
        private final double df;
        private final DoubleUnaryOperator powm1;

        StudentsTSampler(UniformRandomProvider rng, double v) {
            super(rng);
            this.df = v;
            double exponent = -2.0 / v;
            this.powm1 = v > 25.0 ? x -> Math.expm1(Math.log(x) * exponent) : x -> Math.pow(x, exponent) - 1.0;
        }

        private StudentsTSampler(UniformRandomProvider rng, StudentsTSampler source) {
            super(rng);
            this.df = source.df;
            this.powm1 = source.powm1;
        }

        @Override
        public double sample() {
            double v;
            double u = InternalUtils.makeNonZeroDouble(this.nextLong());
            double w = u * u + (v = StudentsTSampler.makeSignedDouble(this.nextLong())) * v;
            if (w > 1.0) {
                return this.sample();
            }
            double c2 = u * u / w;
            double r2 = this.df * this.powm1.applyAsDouble(w);
            return Math.copySign(Math.sqrt(r2 * c2), v);
        }

        @Override
        public StudentsTSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new StudentsTSampler(rng, this);
        }

        private static double makeSignedDouble(long bits) {
            return (double)(bits >> 10) * (double)1.110223E-16f;
        }
    }
}

