/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.AppendableJoiner;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.text.TextStringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class AppendableJoinerTest {
    AppendableJoinerTest() {
    }

    @Test
    void testAllBuilderPropertiesStringBuilder() {
        AppendableJoiner joiner = AppendableJoiner.builder().setPrefix((CharSequence)"<").setDelimiter((CharSequence)".").setSuffix((CharSequence)">").setElementAppender((a, e) -> a.append(String.valueOf(e))).get();
        StringBuilder sbuilder = new StringBuilder("A");
        Assertions.assertEquals((Object)"A<B.C>", (Object)joiner.join(sbuilder, new Object[]{"B", "C"}).toString());
        sbuilder.append("1");
        Assertions.assertEquals((Object)"A<B.C>1<D.E>", (Object)joiner.join(sbuilder, Arrays.asList("D", "E")).toString());
    }

    @Test
    void testBuildDefaultStringBuilder() {
        AppendableJoiner.Builder builder = AppendableJoiner.builder();
        Assertions.assertNotSame((Object)builder.get(), (Object)builder.get());
        AppendableJoiner joiner = builder.get();
        StringBuilder sbuilder = new StringBuilder("A");
        Assertions.assertEquals((Object)"ABC", (Object)joiner.join(sbuilder, new Object[]{"B", "C"}).toString());
        sbuilder.append("1");
        Assertions.assertEquals((Object)"ABC1DE", (Object)joiner.join(sbuilder, new Object[]{"D", "E"}).toString());
    }

    @Test
    void testBuilder() {
        Assertions.assertNotSame((Object)AppendableJoiner.builder(), (Object)AppendableJoiner.builder());
    }

    @ParameterizedTest
    @ValueSource(classes={StringBuilder.class, StringBuffer.class, StringWriter.class, StrBuilder.class, TextStringBuilder.class})
    void testDelimiterAppendable(Class<? extends Appendable> clazz) throws Exception {
        AppendableJoiner joiner = AppendableJoiner.builder().setDelimiter((CharSequence)".").get();
        Appendable sbuilder = clazz.newInstance();
        sbuilder.append("A");
        Assertions.assertEquals((Object)"AB.C", (Object)joiner.joinA(sbuilder, new Object[]{"B", "C"}).toString());
        sbuilder.append("1");
        Assertions.assertEquals((Object)"AB.C1D.E", (Object)joiner.joinA(sbuilder, Arrays.asList("D", "E")).toString());
    }

    @Test
    void testDelimiterStringBuilder() {
        AppendableJoiner joiner = AppendableJoiner.builder().setDelimiter((CharSequence)".").get();
        StringBuilder sbuilder = new StringBuilder("A");
        Assertions.assertEquals((Object)"AB.C", (Object)joiner.join(sbuilder, new Object[]{"B", "C"}).toString());
        sbuilder.append("1");
        Assertions.assertEquals((Object)"AB.C1D.E", (Object)joiner.join(sbuilder, Arrays.asList("D", "E")).toString());
    }

    @Test
    void testToCharSequenceStringBuilder1() {
        AppendableJoiner joiner = AppendableJoiner.builder().setPrefix((CharSequence)"<").setDelimiter((CharSequence)".").setSuffix((CharSequence)">").setElementAppender((a, e) -> a.append("|").append(Objects.toString(e))).get();
        StringBuilder sbuilder = new StringBuilder("A");
        Assertions.assertEquals((Object)"A<|B.|C>", (Object)joiner.join(sbuilder, new Object[]{"B", "C"}).toString());
        sbuilder.append("1");
        Assertions.assertEquals((Object)"A<|B.|C>1<|D.|E>", (Object)joiner.join(sbuilder, Arrays.asList("D", "E")).toString());
    }

    @Test
    void testToCharSequenceStringBuilder2() {
        AppendableJoiner joiner = AppendableJoiner.builder().setElementAppender((a, e) -> e.render((Appendable)a)).get();
        StringBuilder sbuilder = new StringBuilder("[");
        Assertions.assertEquals((Object)"[B!C!", (Object)joiner.join(sbuilder, (Object[])new Fixture[]{new Fixture("B"), new Fixture("C")}).toString());
        sbuilder.append("]");
        Assertions.assertEquals((Object)"[B!C!]D!E!", (Object)joiner.join(sbuilder, Arrays.asList(new Fixture("D"), new Fixture("E"))).toString());
    }

    static class Fixture {
        private final String name;

        Fixture(String name) {
            this.name = name;
        }

        void render(Appendable appendable) throws IOException {
            appendable.append(this.name);
            appendable.append('!');
        }
    }
}

