/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.formats.tiff.AbstractTiffTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TiffBigTiffTest
extends AbstractTiffTest {
    private boolean doImagesMatch(int w, int h, int[] classicRgb, BufferedImage image) {
        int iW = image.getWidth();
        int iH = image.getHeight();
        if (iW != w || iH != h) {
            return false;
        }
        int[] argb = new int[w * h];
        image.getRGB(0, 0, w, h, argb, 0, w);
        for (int i = 0; i < argb.length; ++i) {
            if ((argb[i] & 0xFFFFFF) == (classicRgb[i] & 0xFFFFFF)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void test() throws IOException {
        File[] files;
        File tiffFolder = new File(ImagingTestConstants.TEST_IMAGE_FOLDER, "tiff");
        File bigTiffFolder = new File(tiffFolder, "13");
        File classicFile = new File(bigTiffFolder, "Classic.tif");
        BufferedImage classicImage = Imaging.getBufferedImage((File)classicFile);
        Assertions.assertNotNull((Object)classicImage);
        int w = classicImage.getWidth();
        int h = classicImage.getHeight();
        int[] classicRgb = new int[w * h];
        classicImage.getRGB(0, 0, w, h, classicRgb, 0, w);
        int nTest = 0;
        for (File f : files = bigTiffFolder.listFiles()) {
            String name = f.getName();
            if (!name.toLowerCase().startsWith("bigtiff")) continue;
            BufferedImage image = Imaging.getBufferedImage((File)f);
            Assertions.assertNotNull((Object)image);
            boolean status = this.doImagesMatch(w, h, classicRgb, image);
            Assertions.assertTrue((boolean)status, (String)("BigTIFF content does not match test image for " + name));
            ++nTest;
        }
        Assertions.assertTrue((nTest > 0 ? 1 : 0) != 0, (String)"JUnit test failed to find sample BigTIFF files");
    }
}

