/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.stream.IntStream;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.formats.tiff.AbstractTiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;

public final class TiffRasterDataFloat
extends AbstractTiffRasterData {
    private final float[] data;

    public TiffRasterDataFloat(int width, int height) {
        super(width, height, 1);
        this.data = Allocator.floatArray(this.nCells);
    }

    public TiffRasterDataFloat(int width, int height, float[] data) {
        super(width, height, 1);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    public TiffRasterDataFloat(int width, int height, int samplesPerPixel) {
        super(width, height, samplesPerPixel);
        this.data = Allocator.floatArray(this.nCells);
    }

    public TiffRasterDataFloat(int width, int height, int samplesPerCell, float[] data) {
        super(width, height, samplesPerCell);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    @Override
    public float[] getData() {
        return this.data;
    }

    @Override
    public TiffRasterDataType getDataType() {
        return TiffRasterDataType.FLOAT;
    }

    @Override
    public int[] getIntData() {
        return IntStream.range(0, this.nCells).map(i -> (int)this.data[i]).toArray();
    }

    @Override
    public int getIntValue(int x, int y) {
        return (int)this.data[this.checkCoordinatesAndComputeIndex(x, y, 0)];
    }

    @Override
    public int getIntValue(int x, int y, int i) {
        return (int)this.data[this.checkCoordinatesAndComputeIndex(x, y, 0)];
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics() {
        return new TiffRasterStatistics(this, Float.NaN);
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics(float valueToExclude) {
        return new TiffRasterStatistics(this, valueToExclude);
    }

    @Override
    public float getValue(int x, int y) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, 0)];
    }

    @Override
    public float getValue(int x, int y, int i) {
        return this.data[this.checkCoordinatesAndComputeIndex(x, y, i)];
    }

    @Override
    public void setIntValue(int x, int y, int value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)0)] = value;
    }

    @Override
    public void setIntValue(int x, int y, int i, int value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)0)] = value;
    }

    @Override
    public void setValue(int x, int y, float value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)0)] = value;
    }

    @Override
    public void setValue(int x, int y, int i, float value) {
        this.data[this.checkCoordinatesAndComputeIndex((int)x, (int)y, (int)i)] = value;
    }
}

