/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload.servlet;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.junit.Assert;
import org.junit.Test;

public class ServletFileUploadTest {
    @Test
    public void parseImpliedUtf8() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\ufffds \ufffds the co\ufffdte\ufffdt of the f\ufffdle\n\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"utf8Html\"\r\n\r\nTh\ufffds \ufffds the co\ufffdte\ufffdt of the f\ufffdle\n\r\n-----1234--\r\n".getBytes("UTF-8");
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, "multipart/form-data; boundary=---1234");
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        fileItemFactory.setDefaultCharset("UTF-8");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        List fileItems = upload.parseRequest((HttpServletRequest)request);
        FileItem fileItem = (FileItem)fileItems.get(0);
        Assert.assertTrue((String)fileItem.getString(), (boolean)fileItem.getString().contains("co\ufffdte\ufffdt"));
    }

    @Test
    public void parseParameterMap() throws Exception {
        String text = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] bytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes("US-ASCII");
        MockHttpServletRequest request = new MockHttpServletRequest(bytes, "multipart/form-data; boundary=---1234");
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        Map mappedParameters = upload.parseParameterMap((HttpServletRequest)request);
        Assert.assertTrue((boolean)mappedParameters.containsKey("file"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("file")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("field"));
        Assert.assertEquals((long)1L, (long)((List)mappedParameters.get("field")).size());
        Assert.assertTrue((boolean)mappedParameters.containsKey("multi"));
        Assert.assertEquals((long)2L, (long)((List)mappedParameters.get("multi")).size());
    }
}

