/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class StreamingTest {
    private String getFooter() {
        return "-----1234--\r\n";
    }

    private String getHeader(String fieldName) {
        return "-----1234\r\nContent-Disposition: form-data; name=\"" + fieldName + "\"\r\n\r\n";
    }

    private InputStream newInputStream(final ByteArrayInputStream bais) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return bais.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                return bais.read(b, off, Math.min(len, 3));
            }
        };
    }

    private byte[] newRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");){
            int add = 16;
            int num = 0;
            for (int i = 0; i < 16384; i += add) {
                if (++add == 32) {
                    add = 16;
                }
                osw.write(this.getHeader("field" + num++));
                osw.flush();
                for (int j = 0; j < i; ++j) {
                    baos.write((byte)j);
                }
                osw.write("\r\n");
            }
            osw.write(this.getFooter());
        }
        return baos.toByteArray();
    }

    private byte[] newShortRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");){
            osw.write(this.getHeader("field"));
            osw.write("123");
            osw.write("\r\n");
            osw.write(this.getFooter());
        }
        return baos.toByteArray();
    }

    private List<FileItem> parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(new ByteArrayInputStream(bytes), bytes.length);
    }

    private List<FileItem> parseUpload(InputStream in, int length) throws FileUploadException {
        String contentType = "multipart/form-data; boundary=---1234";
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(in, length, "multipart/form-data; boundary=---1234");
        return upload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)request));
    }

    private FileItemIterator parseUpload(int length, InputStream in) throws FileUploadException, IOException {
        String contentType = "multipart/form-data; boundary=---1234";
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(in, length, "multipart/form-data; boundary=---1234");
        return upload.getItemIterator((RequestContext)new ServletRequestContext((HttpServletRequest)request));
    }

    @Test
    public void testFileUpload() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        List<FileItem> fileItems = this.parseUpload(request);
        Iterator<FileItem> fileIter = fileItems.iterator();
        int add = 16;
        int num = 0;
        for (int i = 0; i < 16384; i += add) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = fileIter.next();
            Assert.assertEquals((Object)("field" + num++), (Object)item.getFieldName());
            byte[] bytes = item.get();
            Assert.assertEquals((long)i, (long)bytes.length);
            for (int j = 0; j < i; ++j) {
                Assert.assertEquals((long)((byte)j), (long)bytes[j]);
            }
        }
        Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testFILEUPLOAD135() throws IOException, FileUploadException {
        byte[] request = this.newShortRequest();
        ByteArrayInputStream bais = new ByteArrayInputStream(request);
        try (InputStream inputStream = this.newInputStream(bais);){
            List<FileItem> fileItems = this.parseUpload(inputStream, request.length);
            Iterator<FileItem> fileIter = fileItems.iterator();
            Assert.assertTrue((boolean)fileIter.hasNext());
            FileItem item = fileIter.next();
            Assert.assertEquals((Object)"field", (Object)item.getFieldName());
            byte[] bytes = item.get();
            Assert.assertEquals((long)3L, (long)bytes.length);
            Assert.assertEquals((long)49L, (long)bytes[0]);
            Assert.assertEquals((long)50L, (long)bytes[1]);
            Assert.assertEquals((long)51L, (long)bytes[2]);
            Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFileUploadException() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        byte[] invalidRequest = new byte[request.length - 11];
        System.arraycopy(request, 0, invalidRequest, 0, request.length - 11);
        Assertions.assertInstanceOf(MultipartStream.MalformedStreamException.class, (Object)((FileUploadBase.IOFileUploadException)Assertions.assertThrows(FileUploadBase.IOFileUploadException.class, () -> this.parseUpload(invalidRequest))).getCause());
    }

    @Test
    public void testInvalidFileNameException() throws Exception {
        String fileName = "foo.exe\u0000.png";
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n";
        byte[] reqBytes = "-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.exe\u0000.png\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n".getBytes("US-ASCII");
        FileItemIterator fileItemIter = this.parseUpload(reqBytes.length, new ByteArrayInputStream(reqBytes));
        FileItemStream fileItemStream = fileItemIter.next();
        InvalidFileNameException e = (InvalidFileNameException)Assertions.assertThrows(InvalidFileNameException.class, () -> ((FileItemStream)fileItemStream).getName());
        Assert.assertEquals((Object)"foo.exe\u0000.png", (Object)e.getName());
        Assert.assertTrue((e.getMessage().indexOf("foo.exe\u0000.png") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((e.getMessage().indexOf("foo.exe\\0.png") != -1 ? 1 : 0) != 0);
        List<FileItem> fileItems = this.parseUpload(reqBytes);
        FileItem fileItem = fileItems.get(0);
        e = (InvalidFileNameException)Assertions.assertThrows(InvalidFileNameException.class, () -> ((FileItem)fileItem).getName());
        Assert.assertEquals((Object)"foo.exe\u0000.png", (Object)e.getName());
        Assert.assertTrue((e.getMessage().indexOf("foo.exe\u0000.png") == -1 ? 1 : 0) != 0);
        Assert.assertTrue((e.getMessage().indexOf("foo.exe\\0.png") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testIOException() throws IOException {
        byte[] request = this.newRequest();
        FilterInputStream stream = new FilterInputStream(new ByteArrayInputStream(request)){
            private int num;

            @Override
            public int read() throws IOException {
                if (++this.num > 123) {
                    throw new IOException("123");
                }
                return super.read();
            }

            @Override
            public int read(byte[] buffer, int offset, int length) throws IOException {
                for (int i = 0; i < length; ++i) {
                    int res = this.read();
                    if (res == -1) {
                        return i == 0 ? -1 : i;
                    }
                    buffer[offset + i] = (byte)res;
                }
                return length;
            }
        };
        FileUploadException e = (FileUploadException)Assertions.assertThrows(FileUploadException.class, () -> this.parseUpload(stream, request.length));
        Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        Assert.assertEquals((Object)"123", (Object)e.getCause().getMessage());
    }
}

