/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp2.datasources.SharedPoolDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestInstanceKeyDataSource {
    private static final String DRIVER = "org.apache.commons.dbcp2.TesterDriver";
    private static final String URL = "jdbc:apache:commons:testdriver";
    private static final String USER = "foo";
    private static final String PASS = "bar";
    private DriverAdapterCPDS pcds;
    private SharedPoolDataSource spds;

    @BeforeEach
    public void setUp() throws ClassNotFoundException {
        this.pcds = new DriverAdapterCPDS();
        this.pcds.setDriver(DRIVER);
        this.pcds.setUrl(URL);
        this.pcds.setUser(USER);
        this.pcds.setPassword(PASS);
        this.pcds.setPoolPreparedStatements(false);
        this.spds = new SharedPoolDataSource();
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.spds.close();
    }

    @Test
    void testConnection() throws SQLException, ClassNotFoundException {
        this.spds = new SharedPoolDataSource();
        this.pcds.setDriver(DRIVER);
        this.pcds.setUrl(URL);
        this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)this.pcds);
        PooledConnectionAndInfo info = this.spds.getPooledConnectionAndInfo(null, null);
        Assertions.assertNull((Object)info.getUserName());
        Assertions.assertNull((Object)info.getPassword());
        try (Connection conn = this.spds.getConnection();){
            Assertions.assertNotNull((Object)conn);
        }
    }

    @Test
    void testConnectionPoolDataSource() {
        Assertions.assertEquals((Object)this.pcds, (Object)this.spds.getConnectionPoolDataSource());
    }

    @Test
    void testConnectionPoolDataSourceAlreadySet() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)new DriverAdapterCPDS()));
    }

    @Test
    void testConnectionPoolDataSourceAlreadySetUsingJndi() {
        this.spds = new SharedPoolDataSource();
        this.spds.setDataSourceName("anything");
        Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setConnectionPoolDataSource((ConnectionPoolDataSource)new DriverAdapterCPDS()));
    }

    @Test
    void testDataSourceName() {
        this.spds = new SharedPoolDataSource();
        Assertions.assertNull((Object)this.spds.getDataSourceName());
        this.spds.setDataSourceName("anything");
        Assertions.assertEquals((Object)"anything", (Object)this.spds.getDataSourceName());
    }

    @Test
    void testDataSourceNameAlreadySet() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setDataSourceName("anything"));
    }

    @Test
    void testDataSourceNameAlreadySetUsingJndi() {
        this.spds = new SharedPoolDataSource();
        this.spds.setDataSourceName("anything");
        Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setDataSourceName("anything"));
    }

    @Test
    void testDefaultBlockWhenExhausted() {
        this.spds.setDefaultBlockWhenExhausted(true);
        Assertions.assertTrue((boolean)this.spds.getDefaultBlockWhenExhausted());
        this.spds.setDefaultBlockWhenExhausted(false);
        Assertions.assertFalse((boolean)this.spds.getDefaultBlockWhenExhausted());
    }

    @Test
    void testDefaultEvictionPolicyClassName() {
        this.spds.setDefaultEvictionPolicyClassName(Object.class.getName());
        Assertions.assertEquals((Object)Object.class.getName(), (Object)this.spds.getDefaultEvictionPolicyClassName());
    }

    @Test
    void testDefaultLifo() {
        this.spds.setDefaultLifo(true);
        Assertions.assertTrue((boolean)this.spds.getDefaultLifo());
        this.spds.setDefaultLifo(false);
        Assertions.assertFalse((boolean)this.spds.getDefaultLifo());
    }

    @Test
    void testDefaultMinIdle() {
        this.spds.setDefaultMinIdle(10);
        Assertions.assertEquals((int)10, (int)this.spds.getDefaultMinIdle());
    }

    @Test
    void testDefaultReadOnly() {
        this.spds.setDefaultReadOnly(Boolean.valueOf(true));
        Assertions.assertTrue((boolean)this.spds.isDefaultReadOnly());
        this.spds.setDefaultReadOnly(Boolean.valueOf(false));
        Assertions.assertFalse((boolean)this.spds.isDefaultReadOnly());
    }

    @Test
    void testDefaultSoftMinEvictableIdleTimeMillis() {
        this.spds.setDefaultSoftMinEvictableIdleTimeMillis(10L);
        Assertions.assertEquals((long)10L, (long)this.spds.getDefaultSoftMinEvictableIdleTimeMillis());
    }

    @Test
    void testDefaultTestOnCreate() {
        this.spds.setDefaultTestOnCreate(false);
        Assertions.assertFalse((boolean)this.spds.getDefaultTestOnCreate());
        this.spds.setDefaultTestOnCreate(true);
        Assertions.assertTrue((boolean)this.spds.getDefaultTestOnCreate());
    }

    @Test
    void testDefaultTransactionIsolation() {
        Assertions.assertEquals((int)-1, (int)this.spds.getDefaultTransactionIsolation());
        this.spds.setDefaultTransactionIsolation(2);
        Assertions.assertEquals((int)2, (int)this.spds.getDefaultTransactionIsolation());
    }

    @Test
    void testDefaultTransactionIsolationInvalid() {
        Assertions.assertEquals((int)-1, (int)this.spds.getDefaultTransactionIsolation());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.spds.setDefaultTransactionIsolation(Integer.MAX_VALUE));
    }

    @Test
    void testDescription() {
        this.spds.setDescription("anything");
        Assertions.assertEquals((Object)"anything", (Object)this.spds.getDescription());
    }

    @Test
    void testExceptionOnSetupDefaults() throws Exception {
        try (ThrowOnSetupDefaultsDataSource tds = new ThrowOnSetupDefaultsDataSource();){
            int numConnections = tds.getNumActive();
            Assertions.assertThrows(SQLException.class, () -> tds.getConnection(USER, PASS));
            Assertions.assertEquals((int)numConnections, (int)tds.getNumActive());
        }
    }

    @Test
    void testIsWrapperFor() throws Exception {
        Assertions.assertTrue((boolean)this.spds.isWrapperFor(InstanceKeyDataSource.class));
        Assertions.assertTrue((boolean)this.spds.isWrapperFor(AutoCloseable.class));
    }

    @Test
    void testJndiEnvironment() {
        Assertions.assertNull((Object)this.spds.getJndiEnvironment("name"));
        Properties properties = new Properties();
        properties.setProperty("name", "clarke");
        this.spds.setJndiEnvironment(properties);
        Assertions.assertEquals((Object)"clarke", (Object)this.spds.getJndiEnvironment("name"));
        this.spds.setJndiEnvironment("name", "asimov");
        Assertions.assertEquals((Object)"asimov", (Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    void testJndiNullProperties() {
        Assertions.assertThrows(NullPointerException.class, () -> this.spds.setJndiEnvironment(null));
    }

    @Test
    void testJndiPropertiesCleared() {
        this.spds.setJndiEnvironment("name", "king");
        Assertions.assertEquals((Object)"king", (Object)this.spds.getJndiEnvironment("name"));
        Properties properties = new Properties();
        properties.setProperty("fish", "kohi");
        this.spds.setJndiEnvironment(properties);
        Assertions.assertNull((Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    void testJndiPropertiesNotInitialized() {
        Assertions.assertNull((Object)this.spds.getJndiEnvironment("name"));
        this.spds.setJndiEnvironment("name", "king");
        Assertions.assertEquals((Object)"king", (Object)this.spds.getJndiEnvironment("name"));
    }

    @Test
    void testLoginTimeout() {
        this.spds.setLoginTimeout(10);
        Assertions.assertEquals((int)10, (int)this.spds.getLoginTimeout());
    }

    @Test
    void testLogWriter() {
        this.spds.setLogWriter(new PrintWriter(System.out));
        Assertions.assertNotNull((Object)this.spds.getLogWriter());
    }

    @Test
    void testLogWriterAutoInitialized() {
        Assertions.assertNotNull((Object)this.spds.getLogWriter());
    }

    @Test
    void testMaxConnLifetimeMillis() {
        Assertions.assertEquals((long)-1L, (long)this.spds.getMaxConnLifetimeMillis());
        this.spds.setMaxConnLifetimeMillis(10L);
        Assertions.assertEquals((long)10L, (long)this.spds.getMaxConnLifetimeMillis());
    }

    @Test
    void testRollbackAfterValidation() {
        Assertions.assertFalse((boolean)this.spds.isRollbackAfterValidation());
        this.spds.setRollbackAfterValidation(true);
        Assertions.assertTrue((boolean)this.spds.isRollbackAfterValidation());
    }

    @Test
    void testRollbackAfterValidationWithConnectionCalled() throws SQLException {
        try (Connection connection = this.spds.getConnection();){
            Assertions.assertFalse((boolean)this.spds.isRollbackAfterValidation());
            Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setRollbackAfterValidation(true));
        }
    }

    @Test
    void testUnwrap() throws Exception {
        Assertions.assertSame((Object)this.spds.unwrap(InstanceKeyDataSource.class), (Object)this.spds);
        Assertions.assertSame((Object)this.spds.unwrap(AutoCloseable.class), (Object)this.spds);
    }

    @Test
    void testValidationQuery() {
        Assertions.assertNull((Object)this.spds.getValidationQuery());
        this.spds.setValidationQuery("anything");
        Assertions.assertEquals((Object)"anything", (Object)this.spds.getValidationQuery());
    }

    @Test
    void testValidationQueryTimeout() {
        Assertions.assertEquals((int)-1, (int)this.spds.getValidationQueryTimeout());
        this.spds.setValidationQueryTimeout(10);
        Assertions.assertEquals((int)10, (int)this.spds.getValidationQueryTimeout());
    }

    @Test
    void testValidationQueryTimeoutDuration() {
        Assertions.assertEquals((Object)Duration.ofSeconds(-1L), (Object)this.spds.getValidationQueryTimeoutDuration());
        this.spds.setValidationQueryTimeout(Duration.ofSeconds(10L));
        Assertions.assertEquals((Object)Duration.ofSeconds(10L), (Object)this.spds.getValidationQueryTimeoutDuration());
    }

    @Test
    void testValidationQueryWithConnectionCalled() throws SQLException {
        try (Connection connection = this.spds.getConnection();){
            Assertions.assertNull((Object)this.spds.getValidationQuery());
            Assertions.assertThrows(IllegalStateException.class, () -> this.spds.setValidationQuery("anything"));
        }
    }

    private static final class ThrowOnSetupDefaultsDataSource
    extends SharedPoolDataSource {
        private static final long serialVersionUID = -448025812063133259L;

        ThrowOnSetupDefaultsDataSource() {
        }

        protected void setupDefaults(Connection connection, String userName) throws SQLException {
            throw new SQLException("bang!");
        }
    }
}

